/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.servicediscovery.dns;

import io.smallrye.stork.api.config.ConfigWithType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DnsConfiguration
implements ConfigWithType {
    private final Map<String, String> parameters;

    public DnsConfiguration(Map<String, String> params) {
        this.parameters = Collections.unmodifiableMap(params);
    }

    public DnsConfiguration() {
        this.parameters = Collections.emptyMap();
    }

    public String type() {
        return "dns";
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    private DnsConfiguration extend(String key, String value) {
        HashMap<String, String> copy = new HashMap<String, String>(this.parameters);
        copy.put(key, value);
        return new DnsConfiguration(copy);
    }

    public String getDnsServers() {
        String result = this.parameters.get("dns-servers");
        return result == null ? "none" : result;
    }

    public DnsConfiguration withDnsServers(String value) {
        return this.extend("dns-servers", value);
    }

    public String getHostname() {
        return this.parameters.get("hostname");
    }

    public DnsConfiguration withHostname(String value) {
        return this.extend("hostname", value);
    }

    public String getRecordType() {
        String result = this.parameters.get("record-type");
        return result == null ? "SRV" : result;
    }

    public DnsConfiguration withRecordType(String value) {
        return this.extend("record-type", value);
    }

    public String getPort() {
        return this.parameters.get("port");
    }

    public DnsConfiguration withPort(String value) {
        return this.extend("port", value);
    }

    public String getRefreshPeriod() {
        String result = this.parameters.get("refresh-period");
        return result == null ? "5M" : result;
    }

    public DnsConfiguration withRefreshPeriod(String value) {
        return this.extend("refresh-period", value);
    }

    public String getSecure() {
        return this.parameters.get("secure");
    }

    public DnsConfiguration withSecure(String value) {
        return this.extend("secure", value);
    }

    public String getRecursionDesired() {
        String result = this.parameters.get("recursion-desired");
        return result == null ? "true" : result;
    }

    public DnsConfiguration withRecursionDesired(String value) {
        return this.extend("recursion-desired", value);
    }

    public String getResolveSrv() {
        String result = this.parameters.get("resolve-srv");
        return result == null ? "true" : result;
    }

    public DnsConfiguration withResolveSrv(String value) {
        return this.extend("resolve-srv", value);
    }

    public String getDnsTimeout() {
        String result = this.parameters.get("dns-timeout");
        return result == null ? "5s" : result;
    }

    public DnsConfiguration withDnsTimeout(String value) {
        return this.extend("dns-timeout", value);
    }

    public String getFailOnError() {
        String result = this.parameters.get("fail-on-error");
        return result == null ? "false" : result;
    }

    public DnsConfiguration withFailOnError(String value) {
        return this.extend("fail-on-error", value);
    }
}

