/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.testing.executor.junit;

import io.takari.maven.testing.TestProperties;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.junit.runners.model.InitializationError;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

abstract class MavenVersionResolver {
    private static final XPathFactory xpathFactory = XPathFactory.newInstance();
    private static final DocumentBuilderFactory documentBuilderFactory;

    static {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(false);
        documentBuilderFactory = factory;
    }

    MavenVersionResolver() {
    }

    public void resolve(String[] versions) throws Exception {
        List<Repository> repositories = null;
        TestProperties properties = new TestProperties();
        String[] stringArray = versions;
        int n = versions.length;
        int n2 = 0;
        while (n2 < n) {
            File mavenHome;
            String version;
            block10: {
                File basedir;
                version = stringArray[n2];
                if (this.isSnapshot(version) && !this.isSnapshot(properties.getPluginVersion())) {
                    String msg = String.format("Cannot test %s plugin release with %s maven", properties.getPluginVersion(), version);
                    this.error(version, new IllegalStateException(msg));
                }
                if (!(mavenHome = new File(basedir = new File("target/maven-installation").getCanonicalFile(), "apache-maven-" + version).getCanonicalFile()).isDirectory()) {
                    if (repositories == null) {
                        repositories = this.getRepositories(properties);
                    }
                    Authenticator defaultAuthenticator = MavenVersionResolver.getDefaultAuthenticator();
                    try {
                        try {
                            this.createMavenInstallation(repositories, version, properties.getLocalRepository(), basedir);
                        }
                        catch (Exception e) {
                            this.error(version, e);
                            Authenticator.setDefault(defaultAuthenticator);
                            break block10;
                        }
                    }
                    catch (Throwable throwable) {
                        Authenticator.setDefault(defaultAuthenticator);
                        throw throwable;
                    }
                    Authenticator.setDefault(defaultAuthenticator);
                }
            }
            if (mavenHome.isDirectory()) {
                this.resolved(mavenHome, version);
            }
            ++n2;
        }
    }

    private static Authenticator getDefaultAuthenticator() throws ReflectiveOperationException {
        Method getDefault;
        try {
            getDefault = Authenticator.class.getMethod("getDefault", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        return (Authenticator)getDefault.invoke(null, new Object[0]);
    }

    private boolean isSnapshot(String version) {
        return version != null && version.endsWith("-SNAPSHOT");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void unarchive(File archive, File directory) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TarArchiveInputStream ais = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new FileInputStream(archive)));){
            while (true) {
                TarArchiveEntry entry;
                if ((entry = ais.getNextTarEntry()) == null) {
                    return;
                }
                if (!entry.isFile()) continue;
                String name = entry.getName();
                File file = new File(directory, name);
                file.getParentFile().mkdirs();
                Throwable throwable2 = null;
                Object var10_14 = null;
                try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
                    this.copy((InputStream)ais, os);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                        throw throwable2;
                    }
                    if (throwable2 == throwable3) throw throwable2;
                    throwable2.addSuppressed(throwable3);
                    throw throwable2;
                }
                int mode = entry.getMode();
                if (mode == -1 || (mode & 0x40) == 0) continue;
                try {
                    Path path = file.toPath();
                    Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(path, new LinkOption[0]);
                    permissions.add(PosixFilePermission.OWNER_EXECUTE);
                    Files.setPosixFilePermissions(path, permissions);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    private List<Repository> getRepositories(TestProperties properties) throws Exception {
        Map<String, Credentials> credentials = this.getCredentials(properties);
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        for (String property : properties.getRepositories()) {
            InputSource is = new InputSource(new StringReader("<repository>" + property + "</repository>"));
            Element repository = (Element)xpathFactory.newXPath().compile("/repository").evaluate(is, XPathConstants.NODE);
            String url = this.getChildValue(repository, "url");
            if (url == null) continue;
            if (!url.endsWith("/")) {
                url = String.valueOf(url) + "/";
            }
            String id = this.getChildValue(repository, "id");
            repositories.add(new Repository(new URL(url), credentials.get(id)));
        }
        return repositories;
    }

    private Map<String, Credentials> getCredentials(TestProperties properties) throws IOException {
        File userSettings = properties.getUserSettings();
        if (userSettings == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Credentials> result = new HashMap<String, Credentials>();
        try {
            Document document = documentBuilderFactory.newDocumentBuilder().parse(userSettings);
            NodeList servers = (NodeList)xpathFactory.newXPath().compile("//settings/servers/server").evaluate(document, XPathConstants.NODESET);
            int i = 0;
            while (i < servers.getLength()) {
                Element server = (Element)servers.item(i);
                String id = this.getChildValue(server, "id");
                String username = this.getChildValue(server, "username");
                String password = this.getChildValue(server, "password");
                if (id != null && username != null) {
                    result.put(id, new Credentials(username, password));
                }
                ++i;
            }
        }
        catch (ParserConfigurationException | XPathExpressionException | SAXException exception) {}
        return result;
    }

    private String getChildValue(Element server, String name) {
        NodeList children = server.getElementsByTagName(name);
        if (children.getLength() != 1) {
            return null;
        }
        String value = ((Element)children.item(0)).getTextContent();
        if (value != null) {
            value = value.trim();
        }
        return !value.isEmpty() ? value : null;
    }

    private String getXPathString(InputSource is, String path) throws Exception {
        String value = xpathFactory.newXPath().compile(path).evaluate(is);
        if (value == null) {
            return null;
        }
        return !(value = value.trim()).isEmpty() ? value : null;
    }

    private void createMavenInstallation(List<Repository> repositories, String version, File localrepo, File targetdir) throws Exception {
        String versionDir = "org/apache/maven/apache-maven/" + version + "/";
        String filename = "apache-maven-" + version + "-bin.tar.gz";
        File archive = new File(localrepo, String.valueOf(versionDir) + filename);
        if (archive.canRead()) {
            this.unarchive(archive, targetdir);
            return;
        }
        IOException cause = null;
        for (Repository repository : repositories) {
            String effectiveVersion;
            this.setHttpCredentials(repository.credentials);
            if (this.isSnapshot(version)) {
                try {
                    effectiveVersion = this.getQualifiedVersion(repository.url, versionDir);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    continue;
                }
                catch (IOException e) {
                    cause = e;
                    continue;
                }
                if (effectiveVersion == null) {
                    continue;
                }
            } else {
                effectiveVersion = version;
            }
            filename = "apache-maven-" + effectiveVersion + "-bin.tar.gz";
            archive = new File(localrepo, String.valueOf(versionDir) + filename);
            if (archive.canRead()) {
                this.unarchive(archive, targetdir);
                return;
            }
            URL resource = new URL(repository.url, String.valueOf(versionDir) + filename);
            try {
                Throwable throwable = null;
                Object var14_17 = null;
                try (InputStream is = this.openStream(resource);){
                    archive.getParentFile().mkdirs();
                    File tmpfile = File.createTempFile(filename, ".tmp", archive.getParentFile());
                    try {
                        this.copy(is, tmpfile);
                        this.unarchive(tmpfile, targetdir);
                        Files.move(tmpfile.toPath(), archive.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                    }
                    finally {
                        tmpfile.delete();
                    }
                    return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException e) {
                cause = e;
            }
        }
        FileNotFoundException exception = new FileNotFoundException("Could not download maven version " + version + " from any configured repository");
        exception.initCause(cause);
        throw exception;
    }

    private void setHttpCredentials(final Credentials credentials) {
        Authenticator authenticator = null;
        if (credentials != null) {
            authenticator = new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(credentials.username, credentials.password.toCharArray());
                }
            };
        }
        Authenticator.setDefault(authenticator);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getQualifiedVersion(URL repository, String versionDir) throws Exception {
        URL resource = new URL(repository, String.valueOf(versionDir) + "maven-metadata.xml");
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream is = this.openStream(resource);){
            String string;
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            this.copy(is, buf);
            InputSource xml = new InputSource(new ByteArrayInputStream(buf.toByteArray()));
            String version = this.getXPathString(xml, "//metadata/versioning/snapshotVersions/snapshotVersion[extension='tar.gz']/value");
            if (version == null) {
                return null;
            }
            if ((version = version.trim()).isEmpty()) {
                string = null;
                return string;
            }
            string = version;
            return string;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    private InputStream openStream(URL resource) throws IOException {
        ArrayDeque<URL> resources = new ArrayDeque<URL>();
        resources.push(resource);
        return this.openStream(resources);
    }

    private InputStream openStream(ArrayDeque<URL> resources) throws IOException {
        if (resources.size() > 5) {
            throw new IOException("Too many redirects: " + resources);
        }
        URL resource = Objects.requireNonNull(resources.peek(), "empty resources");
        URLConnection connection = resource.openConnection();
        if (connection instanceof HttpURLConnection) {
            connection.addRequestProperty("User-Agent", "takari-plugin-testing");
            int responseCode = ((HttpURLConnection)connection).getResponseCode();
            if (responseCode == 301 || responseCode == 302 || responseCode == 307) {
                resources.push(new URL(connection.getHeaderField("Location")));
                return this.openStream(resources);
            }
            if (responseCode < 200 || responseCode > 299) {
                String message = String.format("HTTP/%d %s", responseCode, ((HttpURLConnection)connection).getResponseMessage());
                throw responseCode == 404 ? new FileNotFoundException(message) : new IOException(message);
            }
        }
        return connection.getInputStream();
    }

    private void copy(InputStream from, File to) throws IOException {
        to.getParentFile().mkdirs();
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileOutputStream out = new FileOutputStream(to);){
            this.copy(from, out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void copy(InputStream from, OutputStream to) throws IOException {
        int len;
        byte[] buf = new byte[4096];
        while ((len = from.read(buf)) > 0) {
            to.write(buf, 0, len);
        }
    }

    protected abstract void error(String var1, Exception var2);

    protected abstract void resolved(File var1, String var2) throws InitializationError;

    private static class Credentials {
        public final String username;
        public final String password;

        public Credentials(String username, String password) {
            this.username = username;
            this.password = password;
        }
    }

    private static class Repository {
        public final URL url;
        public final Credentials credentials;

        public Repository(URL url, Credentials credentials) {
            this.url = url;
            this.credentials = credentials;
        }
    }
}

