/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin.maven.migrate;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.joox.Context;
import org.joox.JOOX;
import org.joox.Match;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

final class MavenUtils {
    private static final Pattern PROPERTY_REFERENCE = Pattern.compile("\\$\\{(.*?)\\}");

    private MavenUtils() {
    }

    static Match $$(Context match) {
        return JOOX.$((Context)match).namespace("m", "http://maven.apache.org/POM/4.0.0");
    }

    static Match parsePomXml(Path path) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setExpandEntityReferences(false);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(path.toFile());
        return JOOX.$((Document)document).namespace("m", "http://maven.apache.org/POM/4.0.0");
    }

    static void writePomXml(Path path, Match pom) throws TransformerException, IOException {
        try (FileOutputStream out = new FileOutputStream(path.toFile());){
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMSource source = new DOMSource(pom.document());
            StreamResult target = new StreamResult(out);
            transformer.transform(source, target);
        }
    }

    static boolean refersToProperty(String version) {
        return version != null && PROPERTY_REFERENCE.matcher(version).find();
    }

    static Set<String> propertyNamesReferredFrom(String version) {
        HashSet<String> result = new HashSet<String>();
        Matcher matcher = PROPERTY_REFERENCE.matcher(version);
        while (matcher.find()) {
            result.add(matcher.group(1));
        }
        return result;
    }
}

