/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin.maven.migrate;

import java.nio.file.Path;
import java.util.Objects;
import org.joox.Context;
import org.joox.JOOX;
import org.joox.Match;
import org.wildfly.swarm.plugin.maven.migrate.DependencyLocation;
import org.wildfly.swarm.plugin.maven.migrate.MavenUtils;
import org.wildfly.swarm.plugin.maven.migrate.MigrationAction;

final class MigrateWildFlySwarmDependencyExclusion
implements MigrationAction {
    private final Path pomXml;
    private final DependencyLocation location;
    private final String groupId;
    private final String artifactId;

    MigrateWildFlySwarmDependencyExclusion(Path pomXml, DependencyLocation location, String groupId, String artifactId) {
        this.pomXml = pomXml;
        this.location = location;
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    @Override
    public String describe() {
        return this.pomXml + ": migrate dependency exclusion on " + this.groupId + ":" + this.artifactId + " at " + this.location;
    }

    @Override
    public void execute() throws Exception {
        Match pom = MavenUtils.parsePomXml(this.pomXml);
        this.location.find(pom).xpath("m:exclusions/m:exclusion").filter(exclusion -> {
            String groupId = JOOX.$((Context)exclusion).child("groupId").text();
            String artifactId = JOOX.$((Context)exclusion).child("artifactId").text();
            return this.groupId.equals(groupId) && this.artifactId.equals(artifactId);
        }).each(exclusion -> JOOX.$((Context)exclusion).child("groupId").text("io.thorntail"));
        MavenUtils.writePomXml(this.pomXml, pom);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MigrateWildFlySwarmDependencyExclusion)) {
            return false;
        }
        MigrateWildFlySwarmDependencyExclusion that = (MigrateWildFlySwarmDependencyExclusion)o;
        return Objects.equals(this.pomXml, that.pomXml) && Objects.equals(this.location, that.location) && Objects.equals(this.groupId, that.groupId) && Objects.equals(this.artifactId, that.artifactId);
    }

    public int hashCode() {
        return Objects.hash(this.pomXml, this.location, this.groupId, this.artifactId);
    }
}

