/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin.maven.migrate;

import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.joox.Context;
import org.joox.JOOX;
import org.joox.Match;
import org.wildfly.swarm.plugin.maven.migrate.MavenUtils;
import org.wildfly.swarm.plugin.maven.migrate.MigrationAction;

final class MigrateWildFlySwarmVersionProperty
implements MigrationAction {
    private final Path rootDir;
    private final String versionProperty;
    private final String targetValue;

    MigrateWildFlySwarmVersionProperty(Path rootDir, String versionProperty, String targetValue) {
        this.rootDir = rootDir;
        this.versionProperty = versionProperty;
        this.targetValue = targetValue;
    }

    @Override
    public String describe() {
        return "migrate version property " + this.versionProperty + " to value " + this.targetValue;
    }

    @Override
    public void execute() throws Exception {
        List pomXmls;
        try (Stream<Path> pomXmlsStream = Files.walk(this.rootDir, new FileVisitOption[0]);){
            pomXmls = pomXmlsStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> "pom.xml".equals(p.getFileName().toString())).collect(Collectors.toList());
        }
        for (Path pomXml : pomXmls) {
            AtomicBoolean changed = new AtomicBoolean(false);
            Match pom = MavenUtils.parsePomXml(pomXml);
            pom.xpath("/m:project/m:properties | /m:project/m:profiles/m:profile/m:properties").children(property -> this.versionProperty.equals(JOOX.$((Context)property).tag())).each(property -> {
                JOOX.$((Context)property).text(this.targetValue);
                changed.set(true);
            });
            if (!changed.get()) continue;
            MavenUtils.writePomXml(pomXml, pom);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MigrateWildFlySwarmVersionProperty)) {
            return false;
        }
        MigrateWildFlySwarmVersionProperty that = (MigrateWildFlySwarmVersionProperty)o;
        return Objects.equals(this.versionProperty, that.versionProperty) && Objects.equals(this.targetValue, that.targetValue);
    }

    public int hashCode() {
        return Objects.hash(this.versionProperty, this.targetValue);
    }
}

