/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin.maven.migrate;

import java.util.Objects;
import org.joox.Context;
import org.joox.JOOX;
import org.joox.Match;
import org.wildfly.swarm.plugin.maven.migrate.ProfileLocationType;

final class ProfileLocation {
    private final ProfileLocationType type;
    private final String id;

    static ProfileLocation none() {
        return new ProfileLocation(ProfileLocationType.NONE, "<no profile>");
    }

    static ProfileLocation profile(Match profile) {
        return new ProfileLocation(ProfileLocationType.PROFILE, profile.child("id").text());
    }

    private ProfileLocation(ProfileLocationType type, String id) {
        this.type = type;
        this.id = id;
    }

    Match find(Match pom) {
        switch (this.type) {
            case NONE: {
                return pom;
            }
            case PROFILE: {
                return pom.xpath("m:profiles/m:profile").filter(profile -> {
                    String id = JOOX.$((Context)profile).child("id").text();
                    return this.id.equals(id);
                });
            }
        }
        throw new AssertionError();
    }

    boolean isNone() {
        return this.type == ProfileLocationType.NONE;
    }

    public String toString() {
        if (this.type == ProfileLocationType.NONE) {
            return "";
        }
        return (Object)((Object)this.type) + " " + this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProfileLocation)) {
            return false;
        }
        ProfileLocation that = (ProfileLocation)o;
        return this.type == that.type && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.id});
    }
}

