/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin.maven.migrate;

import java.util.Objects;
import org.joox.Context;
import org.joox.Filter;
import org.joox.JOOX;
import org.joox.Match;
import org.wildfly.swarm.plugin.maven.migrate.DependencyLocationType;
import org.wildfly.swarm.plugin.maven.migrate.PluginLocation;

final class DependencyLocation {
    private final PluginLocation pluginLocation;
    private final DependencyLocationType type;
    private final String groupId;
    private final String artifactId;

    static DependencyLocation dependencyManagement(PluginLocation pluginLocation, Match dependency) {
        return new DependencyLocation(pluginLocation, DependencyLocationType.DEPENDENCY_MANAGEMENT, dependency);
    }

    static DependencyLocation dependencies(PluginLocation pluginLocation, Match dependency) {
        return new DependencyLocation(pluginLocation, DependencyLocationType.DEPENDENCIES, dependency);
    }

    private DependencyLocation(PluginLocation pluginLocation, DependencyLocationType type, Match dependency) {
        this.pluginLocation = pluginLocation;
        this.type = type;
        this.groupId = dependency.child("groupId").text();
        this.artifactId = dependency.child("artifactId").text();
    }

    Match find(Match pom) {
        Match plugin = this.pluginLocation.find(pom);
        Filter dependencyFilter = dependency -> {
            String groupId = JOOX.$((Context)dependency).child("groupId").text();
            String artifactId = JOOX.$((Context)dependency).child("artifactId").text();
            return this.groupId.equals(groupId) && this.artifactId.equals(artifactId);
        };
        switch (this.type) {
            case DEPENDENCY_MANAGEMENT: {
                return plugin.xpath("m:dependencyManagement/m:dependencies/m:dependency").filter(dependencyFilter);
            }
            case DEPENDENCIES: {
                return plugin.xpath("m:dependencies/m:dependency").filter(dependencyFilter);
            }
        }
        throw new AssertionError();
    }

    public String toString() {
        return (Object)((Object)this.type) + " " + this.groupId + ":" + this.artifactId + (this.pluginLocation.isNone() ? "" : " of ") + this.pluginLocation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DependencyLocation)) {
            return false;
        }
        DependencyLocation that = (DependencyLocation)o;
        return Objects.equals(this.pluginLocation, that.pluginLocation) && this.type == that.type && Objects.equals(this.groupId, that.groupId) && Objects.equals(this.artifactId, that.artifactId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.pluginLocation, this.type, this.groupId, this.artifactId});
    }
}

