/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin.maven.migrate;

import java.util.Objects;
import org.joox.Context;
import org.joox.Filter;
import org.joox.JOOX;
import org.joox.Match;
import org.wildfly.swarm.plugin.maven.migrate.PluginLocationType;
import org.wildfly.swarm.plugin.maven.migrate.ProfileLocation;

final class PluginLocation {
    private final ProfileLocation profileLocation;
    private final PluginLocationType type;
    private final String groupId;
    private final String artifactId;

    static PluginLocation none(ProfileLocation profileLocation) {
        return new PluginLocation(profileLocation, PluginLocationType.NONE, null);
    }

    static PluginLocation pluginManagement(ProfileLocation profileLocation, Match plugin) {
        return new PluginLocation(profileLocation, PluginLocationType.PLUGIN_MANAGEMENT, plugin);
    }

    static PluginLocation plugins(ProfileLocation profileLocation, Match plugin) {
        return new PluginLocation(profileLocation, PluginLocationType.PLUGINS, plugin);
    }

    private PluginLocation(ProfileLocation profileLocation, PluginLocationType type, Match plugin) {
        this.profileLocation = profileLocation;
        this.type = type;
        if (plugin != null) {
            this.groupId = plugin.child("groupId").text();
            this.artifactId = plugin.child("artifactId").text();
        } else {
            this.groupId = null;
            this.artifactId = null;
        }
    }

    Match find(Match pom) {
        Match profile = this.profileLocation.find(pom);
        Filter pluginFilter = plugin -> {
            String groupId = JOOX.$((Context)plugin).child("groupId").text();
            String artifactId = JOOX.$((Context)plugin).child("artifactId").text();
            return this.groupId.equals(groupId) && this.artifactId.equals(artifactId);
        };
        switch (this.type) {
            case NONE: {
                return profile;
            }
            case PLUGIN_MANAGEMENT: {
                return profile.xpath("m:build/m:pluginManagement/m:plugins/m:plugin").filter(pluginFilter);
            }
            case PLUGINS: {
                return profile.xpath("m:build/m:plugins/m:plugin").filter(pluginFilter);
            }
        }
        throw new AssertionError();
    }

    boolean isNone() {
        return this.type == PluginLocationType.NONE;
    }

    public String toString() {
        String base = "";
        if (this.type != PluginLocationType.NONE) {
            base = (Object)((Object)this.type) + " " + this.groupId + ":" + this.artifactId;
        }
        return base + (this.profileLocation.isNone() ? "" : " in " + this.profileLocation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PluginLocation)) {
            return false;
        }
        PluginLocation that = (PluginLocation)o;
        return Objects.equals(this.profileLocation, that.profileLocation) && this.type == that.type && Objects.equals(this.groupId, that.groupId) && Objects.equals(this.artifactId, that.artifactId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.profileLocation, this.type, this.groupId, this.artifactId});
    }
}

