/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.asyncsql.impl;

import com.github.mauricio.async.db.Connection;
import com.github.mauricio.async.db.QueryResult;
import com.github.mauricio.async.db.RowData;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.asyncsql.impl.AsyncSQLRowStream;
import io.vertx.ext.asyncsql.impl.ScalaUtils;
import io.vertx.ext.asyncsql.impl.pool.AsyncConnectionPool;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.SQLConnection;
import io.vertx.ext.sql.SQLOptions;
import io.vertx.ext.sql.SQLRowStream;
import io.vertx.ext.sql.TransactionIsolation;
import io.vertx.ext.sql.UpdateResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import scala.Function1;
import scala.Option;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.AbstractFunction1;

public abstract class AsyncSQLConnectionImpl
implements SQLConnection {
    private final ExecutionContext executionContext;
    private volatile boolean inTransaction = false;
    private boolean inAutoCommit = true;
    private final Connection connection;
    private final AsyncConnectionPool pool;

    public AsyncSQLConnectionImpl(Connection connection, AsyncConnectionPool pool, ExecutionContext executionContext) {
        this.connection = connection;
        this.pool = pool;
        this.executionContext = executionContext;
    }

    protected abstract String getStartTransactionStatement();

    public SQLConnection call(String sql, Handler<AsyncResult<ResultSet>> resultHandler) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public SQLConnection callWithParams(String sql, JsonArray params, JsonArray outputs, Handler<AsyncResult<ResultSet>> resultHandler) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public SQLConnection setOptions(SQLOptions options) {
        throw new UnsupportedOperationException("Not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLConnection setAutoCommit(boolean autoCommit, Handler<AsyncResult<Void>> handler) {
        io.vertx.core.Future<Void> fut;
        AsyncSQLConnectionImpl asyncSQLConnectionImpl = this;
        synchronized (asyncSQLConnectionImpl) {
            if (this.inTransaction && autoCommit) {
                this.inTransaction = false;
                fut = ScalaUtils.scalaToVertxVoid(this.connection.sendQuery("COMMIT"), this.executionContext);
            } else {
                fut = io.vertx.core.Future.succeededFuture();
            }
            this.inAutoCommit = autoCommit;
        }
        fut.setHandler(handler);
        return this;
    }

    public SQLConnection execute(String sql, Handler<AsyncResult<Void>> handler) {
        this.beginTransactionIfNeeded((Handler<AsyncResult<Void>>)((Handler)v -> {
            Future future = this.connection.sendQuery(sql);
            future.onComplete(ScalaUtils.toFunction1(ar -> {
                if (ar.succeeded()) {
                    handler.handle((Object)io.vertx.core.Future.succeededFuture());
                } else {
                    handler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }), this.executionContext);
        }));
        return this;
    }

    public SQLConnection query(String sql, Handler<AsyncResult<ResultSet>> handler) {
        this.beginTransactionIfNeeded((Handler<AsyncResult<Void>>)((Handler)v -> {
            io.vertx.core.Future future = ScalaUtils.scalaToVertx(this.connection.sendQuery(sql), this.executionContext);
            future.setHandler(this.handleAsyncQueryResultToResultSet(handler));
        }));
        return this;
    }

    public SQLConnection queryStream(String sql, Handler<AsyncResult<SQLRowStream>> handler) {
        this.beginTransactionIfNeeded((Handler<AsyncResult<Void>>)((Handler)v -> {
            io.vertx.core.Future future = ScalaUtils.scalaToVertx(this.connection.sendQuery(sql), this.executionContext);
            future.setHandler(this.handleAsyncQueryResultToRowStream(handler));
        }));
        return this;
    }

    public SQLConnection queryWithParams(String sql, JsonArray params, Handler<AsyncResult<ResultSet>> handler) {
        this.beginTransactionIfNeeded((Handler<AsyncResult<Void>>)((Handler)v -> {
            Future future = this.connection.sendPreparedStatement(sql, ScalaUtils.toScalaList(params.getList()));
            future.onComplete(ScalaUtils.toFunction1(this.handleAsyncQueryResultToResultSet(handler)), this.executionContext);
        }));
        return this;
    }

    public SQLConnection queryStreamWithParams(String sql, JsonArray params, Handler<AsyncResult<SQLRowStream>> handler) {
        this.beginTransactionIfNeeded((Handler<AsyncResult<Void>>)((Handler)v -> {
            io.vertx.core.Future future = ScalaUtils.scalaToVertx(this.connection.sendPreparedStatement(sql, ScalaUtils.toScalaList(params.getList())), this.executionContext);
            future.setHandler(this.handleAsyncQueryResultToRowStream(handler));
        }));
        return this;
    }

    public SQLConnection update(String sql, Handler<AsyncResult<UpdateResult>> handler) {
        this.beginTransactionIfNeeded((Handler<AsyncResult<Void>>)((Handler)v -> {
            Future future = this.connection.sendQuery(sql);
            future.onComplete(ScalaUtils.toFunction1(this.handleAsyncUpdateResultToResultSet(handler)), this.executionContext);
        }));
        return this;
    }

    public SQLConnection updateWithParams(String sql, JsonArray params, Handler<AsyncResult<UpdateResult>> handler) {
        this.beginTransactionIfNeeded((Handler<AsyncResult<Void>>)((Handler)v -> {
            Future future = this.connection.sendPreparedStatement(sql, ScalaUtils.toScalaList(params.getList()));
            future.onComplete(ScalaUtils.toFunction1(this.handleAsyncUpdateResultToResultSet(handler)), this.executionContext);
        }));
        return this;
    }

    public synchronized void close(Handler<AsyncResult<Void>> handler) {
        this.inAutoCommit = true;
        if (this.inTransaction) {
            this.inTransaction = false;
            io.vertx.core.Future future = ScalaUtils.scalaToVertx(this.connection.sendQuery("COMMIT"), this.executionContext);
            future.setHandler(v -> {
                this.pool.giveBack(this.connection);
                handler.handle((Object)io.vertx.core.Future.succeededFuture());
            });
        } else {
            this.pool.giveBack(this.connection);
            handler.handle((Object)io.vertx.core.Future.succeededFuture());
        }
    }

    public void close() {
        this.close((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public SQLConnection commit(Handler<AsyncResult<Void>> handler) {
        return this.endAndStartTransaction("COMMIT", handler);
    }

    public SQLConnection rollback(Handler<AsyncResult<Void>> handler) {
        return this.endAndStartTransaction("ROLLBACK", handler);
    }

    public SQLConnection setTransactionIsolation(TransactionIsolation transactionIsolation, Handler<AsyncResult<Void>> handler) {
        String sql;
        switch (transactionIsolation) {
            case READ_UNCOMMITTED: {
                sql = "SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED";
                break;
            }
            case REPEATABLE_READ: {
                sql = "SET TRANSACTION ISOLATION LEVEL REPEATABLE READ";
                break;
            }
            case READ_COMMITTED: {
                sql = "SET TRANSACTION ISOLATION LEVEL READ COMMITTED";
                break;
            }
            case SERIALIZABLE: {
                sql = "SET TRANSACTION ISOLATION LEVEL SERIALIZABLE";
                break;
            }
            default: {
                sql = null;
            }
        }
        if (sql == null) {
            handler.handle((Object)io.vertx.core.Future.succeededFuture());
            return this;
        }
        return this.execute(sql, handler);
    }

    public SQLConnection getTransactionIsolation(Handler<AsyncResult<TransactionIsolation>> handler) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public SQLConnection batch(List<String> sqlStatements, Handler<AsyncResult<List<Integer>>> handler) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public SQLConnection batchWithParams(String sqlStatement, List<JsonArray> args, Handler<AsyncResult<List<Integer>>> handler) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public SQLConnection batchCallableWithParams(String sqlStatement, List<JsonArray> inArgs, List<JsonArray> outArgs, Handler<AsyncResult<List<Integer>>> handler) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public <C> C unwrap() {
        return (C)this.connection;
    }

    private SQLConnection endAndStartTransaction(String command, Handler<AsyncResult<Void>> handler) {
        if (this.inTransaction) {
            this.inTransaction = false;
            ScalaUtils.scalaToVertx(this.connection.sendQuery(command), this.executionContext).setHandler(ar -> {
                if (ar.failed()) {
                    handler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                } else {
                    ScalaUtils.scalaToVertx(this.connection.sendQuery("BEGIN"), this.executionContext).setHandler(ar2 -> {
                        if (ar2.failed()) {
                            handler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                        } else {
                            this.inTransaction = true;
                            handler.handle((Object)io.vertx.core.Future.succeededFuture());
                        }
                    });
                }
            });
        } else {
            handler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)new IllegalStateException("Not in transaction currently")));
        }
        return this;
    }

    private synchronized void beginTransactionIfNeeded(Handler<AsyncResult<Void>> action) {
        if (!this.inAutoCommit && !this.inTransaction) {
            this.inTransaction = true;
            ScalaUtils.scalaToVertxVoid(this.connection.sendQuery(this.getStartTransactionStatement()), this.executionContext).setHandler(action);
        } else {
            action.handle((Object)io.vertx.core.Future.succeededFuture());
        }
    }

    private Handler<AsyncResult<QueryResult>> handleAsyncQueryResultToResultSet(Handler<AsyncResult<ResultSet>> handler) {
        return ar -> {
            if (ar.succeeded()) {
                ResultSet result;
                try {
                    result = this.queryResultToResultSet((QueryResult)ar.result());
                }
                catch (Throwable e) {
                    handler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)e));
                    return;
                }
                handler.handle((Object)io.vertx.core.Future.succeededFuture((Object)result));
            } else {
                handler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
            }
        };
    }

    private Handler<AsyncResult<QueryResult>> handleAsyncQueryResultToRowStream(Handler<AsyncResult<SQLRowStream>> handler) {
        return ar -> {
            if (ar.succeeded()) {
                AsyncSQLRowStream rowStream;
                try {
                    rowStream = new AsyncSQLRowStream((QueryResult)ar.result());
                }
                catch (Throwable e) {
                    handler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)e));
                    return;
                }
                handler.handle((Object)io.vertx.core.Future.succeededFuture((Object)rowStream));
            } else {
                handler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
            }
        };
    }

    private ResultSet queryResultToResultSet(QueryResult qr) {
        Option rows = qr.rows();
        if (!rows.isDefined()) {
            return new ResultSet(Collections.emptyList(), Collections.emptyList(), null);
        }
        List names = ScalaUtils.toJavaList(((com.github.mauricio.async.db.ResultSet)rows.get()).columnNames().toList());
        List<JsonArray> arrays = this.rowDataSeqToJsonArray((com.github.mauricio.async.db.ResultSet)rows.get());
        return new ResultSet(names, arrays, null);
    }

    private Handler<AsyncResult<QueryResult>> handleAsyncUpdateResultToResultSet(Handler<AsyncResult<UpdateResult>> handler) {
        return ar -> {
            if (ar.succeeded()) {
                UpdateResult result;
                try {
                    result = this.queryResultToUpdateResult((QueryResult)ar.result());
                }
                catch (Throwable e) {
                    handler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)e));
                    return;
                }
                handler.handle((Object)io.vertx.core.Future.succeededFuture((Object)result));
            } else {
                handler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
            }
        };
    }

    protected UpdateResult queryResultToUpdateResult(QueryResult qr) {
        int affected = (int)qr.rowsAffected();
        return new UpdateResult(affected, new JsonArray());
    }

    private List<JsonArray> rowDataSeqToJsonArray(com.github.mauricio.async.db.ResultSet set) {
        final ArrayList<JsonArray> list = new ArrayList<JsonArray>();
        set.foreach((Function1)new AbstractFunction1<RowData, Void>(){

            public Void apply(RowData row) {
                list.add(ScalaUtils.rowToJsonArray(row));
                return null;
            }
        });
        return list;
    }
}

