/*
 * Decompiled with CFR 0.152.
 */
package javax.cache.configuration;

import javax.cache.Cache;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.Duration;
import javax.cache.expiry.EternalExpiryPolicy;
import javax.cache.expiry.ExpiryPolicy;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jsr107.tck.testutil.CacheTestSupport;
import org.junit.Assert;
import org.junit.Test;

public class ConfigurationTest
extends CacheTestSupport {
    private void validateDefaults(CompleteConfiguration<?, ?> config) {
        Assert.assertEquals(Object.class, (Object)config.getKeyType());
        Assert.assertEquals(Object.class, (Object)config.getValueType());
        Assert.assertFalse((boolean)config.isReadThrough());
        Assert.assertFalse((boolean)config.isWriteThrough());
        Assert.assertTrue((boolean)config.isStoreByValue());
        Assert.assertFalse((boolean)config.isStatisticsEnabled());
        Assert.assertFalse((boolean)config.isManagementEnabled());
        Assert.assertTrue((this.getConfigurationCacheEntryListenerConfigurationSize(config) == 0 ? 1 : 0) != 0);
        junit.framework.Assert.assertNull((Object)config.getCacheLoaderFactory());
        junit.framework.Assert.assertNull((Object)config.getCacheWriterFactory());
        ExpiryPolicy expiryPolicy = (ExpiryPolicy)config.getExpiryPolicyFactory().create();
        Assert.assertTrue((boolean)(expiryPolicy instanceof EternalExpiryPolicy));
        Assert.assertThat((Object)Duration.ETERNAL, (Matcher)CoreMatchers.equalTo((Object)expiryPolicy.getExpiryForCreation()));
        Assert.assertThat((Object)expiryPolicy.getExpiryForAccess(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)expiryPolicy.getExpiryForUpdate(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testValidateFromBasicConfigurationRetrievedFromCache() {
        Cache cache = this.getCacheManager().createCache("basicCache", new MutableBasicConfiguration());
        CompleteConfiguration configuration = (CompleteConfiguration)cache.getConfiguration(CompleteConfiguration.class);
        this.validateDefaults(configuration);
    }

    @Test
    public void testModifyingConfigurationAfterCreateCacheDoesNotModifyCacheConfiguration() {
        MutableBasicConfiguration<Integer, Integer> mutableConfiguration = new MutableBasicConfiguration<Integer, Integer>().setTypes(Integer.class, Integer.class);
        Cache cache = this.getCacheManager().createCache(this.getTestCacheName() + "_", mutableConfiguration);
        mutableConfiguration.setTypes(String.class, String.class);
        Assert.assertEquals(Integer.class, (Object)cache.getConfiguration(Configuration.class).getKeyType());
        Assert.assertEquals(Integer.class, (Object)cache.getConfiguration(Configuration.class).getValueType());
    }

    protected MutableConfiguration newMutableConfiguration() {
        return new MutableConfiguration();
    }

    private int getConfigurationCacheEntryListenerConfigurationSize(CompleteConfiguration config) {
        int i = 0;
        for (Object listenerConfig : config.getCacheEntryListenerConfigurations()) {
            ++i;
        }
        return i;
    }

    public static class MutableBasicConfiguration<K, V>
    implements Configuration<K, V> {
        public static final long serialVersionUID = 201311111637L;
        protected Class<K> keyType = Object.class;
        protected Class<V> valueType = Object.class;
        protected boolean isStoreByValue = true;

        public Class<K> getKeyType() {
            return this.keyType;
        }

        public Class<V> getValueType() {
            return this.valueType;
        }

        public MutableBasicConfiguration<K, V> setTypes(Class<K> keyType, Class<V> valueType) {
            if (keyType == null || valueType == null) {
                throw new NullPointerException("keyType and/or valueType can't be null");
            }
            this.keyType = keyType;
            this.valueType = valueType;
            return this;
        }

        public MutableBasicConfiguration<K, V> setStoreByValue(boolean isStoreByValue) {
            this.isStoreByValue = isStoreByValue;
            return this;
        }

        public boolean isStoreByValue() {
            return this.isStoreByValue;
        }
    }
}

