/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck;

import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.annotation.CacheRemoveAll;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.integration.CompletionListener;
import manager.CacheNameOnEachMethodBlogManagerImpl;
import org.jsr107.tck.testutil.CacheTestSupport;
import org.jsr107.tck.testutil.ExcludeListExcluder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.MethodRule;

public class CacheTest
extends CacheTestSupport<Long, String> {
    @Rule
    public MethodRule rule = new ExcludeListExcluder(this.getClass()){

        @Override
        protected boolean isExcluded(String methodName) {
            if ("testUnwrap".equals(methodName) && CacheTest.this.getUnwrapClass(CacheManager.class) == null) {
                return true;
            }
            return super.isExcluded(methodName);
        }
    };

    @Before
    public void moreSetUp() {
        this.cache = this.getCacheManager().getCache(this.getTestCacheName(), Long.class, String.class);
    }

    @Override
    protected MutableConfiguration<Long, String> newMutableConfiguration() {
        return new MutableConfiguration().setTypes(Long.class, String.class);
    }

    @Test
    public void sameConfiguration() {
        MutableConfiguration config1 = new MutableConfiguration();
        MutableConfiguration config2 = new MutableConfiguration();
        Assert.assertEquals((Object)config1, (Object)config2);
    }

    @Test
    public void simpleAPI() {
        Long key = 1L;
        String value1 = "key";
        this.cache.put((Object)key, (Object)value1);
        String value2 = (String)this.cache.get((Object)key);
        Assert.assertEquals((Object)value1, (Object)value2);
    }

    @Test
    public void clearTest() {
        Long key = 1L;
        String value1 = "key";
        this.cache.put((Object)key, (Object)value1);
        String value2 = (String)this.cache.get((Object)key);
        Assert.assertEquals((Object)value1, (Object)value2);
        this.cache.clear();
        Assert.assertNull((Object)this.cache.get((Object)key));
    }

    @Test
    public void getCacheName() {
        Assert.assertEquals((Object)this.getTestCacheName(), (Object)this.cache.getName());
    }

    @Test
    public void containsKey_Closed() {
        this.cache.close();
        try {
            this.cache.containsKey(null);
            Assert.fail((String)"should have thrown an exception - cache closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void containsKey_Null() {
        try {
            Assert.assertFalse((boolean)this.cache.containsKey(null));
            Assert.fail((String)"should have thrown an exception - null key not allowed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void containsKey() {
        LinkedHashMap<Long, String> data = this.createLSData(3);
        for (Map.Entry entry : data.entrySet()) {
            Assert.assertFalse((String)"before put", (boolean)this.cache.containsKey(entry.getKey()));
            this.cache.put(entry.getKey(), entry.getValue());
            Assert.assertTrue((String)"after put", (boolean)this.cache.containsKey(entry.getKey()));
        }
        for (Long key : data.keySet()) {
            Assert.assertTrue((String)"finally", (boolean)this.cache.containsKey((Object)key));
        }
    }

    @Test
    public void load_Closed() {
        this.cache.close();
        try {
            this.cache.loadAll(null, true, null);
            Assert.fail((String)"should have thrown an exception - cache closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void load_noLoaderNoCompletionListener() {
        HashSet<Long> keys = new HashSet<Long>();
        keys.add(1L);
        CompletionListener NULL_COMPLETION_LISTENER = null;
        this.cache.loadAll(keys, true, NULL_COMPLETION_LISTENER);
    }

    @Test
    public void iterator_Closed() {
        this.cache.close();
        try {
            this.cache.iterator();
            Assert.fail((String)"should have thrown an exception - cache closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void iterator_Empty() {
        Iterator iterator = this.cache.iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.remove();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            iterator.next();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void iterator() {
        LinkedHashMap<Long, String> data = this.createLSData(3);
        this.cache.putAll(data);
        Iterator iterator = this.cache.iterator();
        while (iterator.hasNext()) {
            Cache.Entry next = (Cache.Entry)iterator.next();
            Assert.assertEquals((Object)next.getValue(), (Object)data.get(next.getKey()));
            iterator.remove();
            data.remove(next.getKey());
        }
        Assert.assertTrue((boolean)data.isEmpty());
    }

    @Test
    public void initialise() {
        try {
            this.cache.getCacheManager();
        }
        catch (IllegalStateException e) {
            Assert.fail((String)"Should be able to access the CacheManager for a new Cache");
        }
    }

    @Test
    public void close() {
        this.cache.close();
        this.cache.close();
        try {
            this.cache.get((Object)1L);
            Assert.fail((String)"Should not be able to use a closed Cache");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testCacheUnwrap() {
        Class<?> unwrapClass = this.getUnwrapClass(Cache.class);
        Object unwrappedCache = this.cache.unwrap(unwrapClass);
        Assert.assertTrue((boolean)unwrapClass.isAssignableFrom(unwrappedCache.getClass()));
    }

    @Test
    public void testCacheEntryUnwrap() {
        Class<?> unwrapClass = this.getUnwrapClass(Cache.Entry.class);
        this.cache.put((Object)1L, (Object)"Tonto");
        Cache.Entry entry = (Cache.Entry)this.cache.iterator().next();
        Object unwrappedCacheEntry = entry.unwrap(unwrapClass);
        Assert.assertTrue((boolean)unwrapClass.isAssignableFrom(unwrappedCacheEntry.getClass()));
    }

    @Test
    public void testGetCacheManager() throws Exception {
        String cacheName = "SampleCache";
        URI uri = Caching.getCachingProvider().getDefaultURI();
        ClassLoader cl1 = Thread.currentThread().getContextClassLoader();
        URLClassLoader cl2 = URLClassLoader.newInstance(new URL[0], cl1);
        CacheManager cacheManager1 = Caching.getCachingProvider().getCacheManager(uri, cl1);
        CacheManager cacheManager2 = Caching.getCachingProvider().getCacheManager(uri, (ClassLoader)cl2);
        Assert.assertNotSame((Object)cacheManager1, (Object)cacheManager2);
        cacheManager1.createCache(cacheName, (Configuration)new MutableConfiguration());
        Cache cache1 = cacheManager1.getCache(cacheName);
        cacheManager2.createCache(cacheName, (Configuration)new MutableConfiguration());
        Cache cache2 = cacheManager2.getCache(cacheName);
        Assert.assertSame((Object)cacheManager1, (Object)cache1.getCacheManager());
        Assert.assertSame((Object)cacheManager2, (Object)cache2.getCacheManager());
    }

    @Test
    public void testAnnotations() {
        CacheNameOnEachMethodBlogManagerImpl value = new CacheNameOnEachMethodBlogManagerImpl();
        boolean foundRemoveAllAnnotation = false;
        for (Method m : value.getClass().getMethods()) {
            if (!m.isAnnotationPresent(CacheRemoveAll.class)) continue;
            System.out.println(m.getName());
            foundRemoveAllAnnotation = true;
        }
        Assert.assertTrue((boolean)foundRemoveAllAnnotation);
    }
}

