/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.integration;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.integration.CacheWriter;
import javax.cache.integration.CacheWriterException;
import javax.cache.processor.EntryProcessor;
import org.jsr107.tck.integration.BatchPartialSuccessRecordingClassWriter;
import org.jsr107.tck.integration.CacheWriterClient;
import org.jsr107.tck.integration.CacheWriterServer;
import org.jsr107.tck.integration.FailingCacheWriter;
import org.jsr107.tck.integration.RecordingCacheWriter;
import org.jsr107.tck.processor.AssertNotPresentEntryProcessor;
import org.jsr107.tck.processor.CombineEntryProcessor;
import org.jsr107.tck.processor.RemoveEntryProcessor;
import org.jsr107.tck.processor.SetEntryProcessor;
import org.jsr107.tck.processor.SetEntryWithComputedValueProcessor;
import org.jsr107.tck.testutil.ExcludeListExcluder;
import org.jsr107.tck.testutil.TestSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class CacheWriterTest
extends TestSupport {
    @Rule
    public ExcludeListExcluder rule = new ExcludeListExcluder(this.getClass());
    private Cache<Integer, String> cache;
    private CacheManager cacheManager;
    private RecordingCacheWriter<Integer, String> cacheWriter;
    private CacheWriterServer<Integer, String> cacheWriterServer;

    @Before
    public void onBeforeEachTest() throws IOException {
        this.cacheWriter = new RecordingCacheWriter();
        this.cacheWriterServer = new CacheWriterServer(10000, this.cacheWriter);
        this.cacheWriterServer.open();
        this.cacheManager = Caching.getCachingProvider().getCacheManager();
        CacheWriterClient theCacheWriter = new CacheWriterClient(this.cacheWriterServer.getInetAddress(), this.cacheWriterServer.getPort());
        MutableConfiguration configuration = new MutableConfiguration();
        configuration.setTypes(Integer.class, String.class);
        configuration.setCacheWriterFactory(FactoryBuilder.factoryOf((Serializable)theCacheWriter));
        configuration.setWriteThrough(true);
        this.getCacheManager().createCache("cache-writer-test", (Configuration)configuration);
        this.cache = this.getCacheManager().getCache("cache-writer-test", Integer.class, String.class);
    }

    @After
    public void cleanup() {
        String cacheName = this.cache.getName();
        this.cacheManager.destroyCache(cacheName);
        this.cacheWriterServer.close();
        this.cacheWriterServer = null;
        this.cache = null;
    }

    @Test
    public void shouldNotWriteThroughCallingContainsKeyOnExistingKey() {
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        this.cache.put((Object)1, (Object)"Gudday World");
        Assert.assertEquals((long)1L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        this.cache.containsKey((Object)1);
        Assert.assertEquals((long)1L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
    }

    @Test
    public void shouldNotInvokeWriteThroughCallingContainsKeyOnMissingKey() {
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        this.cache.containsKey((Object)1);
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
    }

    @Test
    public void shouldNotInvokeWriteThroughCallingGetOnMissingEntry() {
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        this.cache.get((Object)1);
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
    }

    @Test
    public void shouldNotInvokeWriteThroughCallingGetOnExistingEntry() {
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        this.cache.put((Object)1, (Object)"Gudday World");
        Assert.assertEquals((long)1L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        String value = (String)this.cache.get((Object)1);
        Assert.assertEquals((Object)"Gudday World", (Object)value);
        Assert.assertEquals((long)1L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
    }

    @Test
    public void shouldNotInvokeWriteThroughCallingGetAll() {
        int NUM_KEYS = 4;
        HashSet<Integer> keys = new HashSet<Integer>();
        for (int i = 1; i <= NUM_KEYS; ++i) {
            keys.add(i);
        }
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        Map map = this.cache.getAll(keys);
        Assert.assertTrue((map.size() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        for (Integer key : keys) {
            this.cache.put((Object)key, (Object)("value" + key));
        }
        Assert.assertEquals((long)NUM_KEYS, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        map = this.cache.getAll(keys);
        Assert.assertEquals((long)keys.size(), (long)map.size());
        Assert.assertEquals((long)NUM_KEYS, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
    }

    @Test
    public void shouldWriteThroughUsingGetAndPut_SingleEntryMultipleTimes() {
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        this.cache.getAndPut((Object)1, (Object)"Gudday World");
        this.cache.getAndPut((Object)1, (Object)"Gudday World");
        this.cache.getAndPut((Object)1, (Object)"Gudday World");
        Assert.assertEquals((long)3L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        Assert.assertTrue((boolean)this.cacheWriter.hasWritten((Object)1));
        Assert.assertEquals((Object)"Gudday World", (Object)this.cacheWriter.get((Object)1));
    }

    @Test
    public void shouldWriteThroughUsingGetAndPut_DifferentEntries() {
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        this.cache.getAndPut((Object)1, (Object)"Gudday World");
        this.cache.getAndPut((Object)2, (Object)"Bonjour World");
        this.cache.getAndPut((Object)3, (Object)"Hello World");
        Assert.assertEquals((long)3L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        Assert.assertTrue((boolean)this.cacheWriter.hasWritten((Object)1));
        Assert.assertEquals((Object)"Gudday World", (Object)this.cacheWriter.get((Object)1));
        Assert.assertTrue((boolean)this.cacheWriter.hasWritten((Object)2));
        Assert.assertEquals((Object)"Bonjour World", (Object)this.cacheWriter.get((Object)2));
        Assert.assertTrue((boolean)this.cacheWriter.hasWritten((Object)3));
        Assert.assertEquals((Object)"Hello World", (Object)this.cacheWriter.get((Object)3));
    }

    @Test
    public void shouldWriteThroughUsingGetAndRemove_MissingSingleEntry() {
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        String value = (String)this.cache.getAndRemove((Object)1);
        Assert.assertEquals((Object)value, null);
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)1L, (long)this.cacheWriter.getDeleteCount());
    }

    @Test
    public void shouldWriteThroughUsingGetAndRemove_ExistingSingleEntry() {
        int nDelete = 0;
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        this.cache.put((Object)1, (Object)"Gudday World");
        String value = (String)this.cache.getAndRemove((Object)1);
        Assert.assertEquals((Object)"Gudday World", (Object)value);
        Assert.assertEquals((long)1L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)(++nDelete), (long)this.cacheWriter.getDeleteCount());
        Assert.assertFalse((boolean)this.cacheWriter.hasWritten((Object)1));
    }

    @Test
    public void shouldNotWriteThroughUsingGetAndReplace_MissingSingleEntry() {
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        String value = (String)this.cache.getAndReplace((Object)1, (Object)"Gudday World");
        Assert.assertEquals((Object)value, null);
        Assert.assertEquals((Object)this.cache.containsKey((Object)1), (Object)false);
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
    }

    @Test
    public void shouldWriteThroughUsingGetAndReplace_ExistingSingleEntry() {
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        this.cache.put((Object)1, (Object)"Gudday World");
        String value = (String)this.cache.getAndReplace((Object)1, (Object)"Hello World");
        Assert.assertEquals((Object)value, (Object)"Gudday World");
        Assert.assertEquals((long)2L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        Assert.assertEquals((Object)this.cache.get((Object)1), (Object)this.cacheWriter.get((Object)1));
        Assert.assertTrue((boolean)this.cacheWriter.hasWritten((Object)1));
    }

    @Test
    public void shouldWriteThroughUsingGetAndReplace_SingleEntryMultipleTimes() {
        int nWrite = 0;
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        String previousValue = (String)this.cache.getAndReplace((Object)1, (Object)"Gudday World");
        Assert.assertEquals((Object)previousValue, null);
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        boolean result = this.cache.putIfAbsent((Object)1, (Object)"Gudday World");
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)(++nWrite), (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        previousValue = (String)this.cache.getAndReplace((Object)1, (Object)"Bonjour World");
        Assert.assertEquals((Object)previousValue, (Object)"Gudday World");
        Assert.assertEquals((Object)this.cache.get((Object)1), (Object)this.cacheWriter.get((Object)1));
        Assert.assertEquals((Object)"Bonjour World", (Object)this.cacheWriter.get((Object)1));
        Assert.assertEquals((Object)"Bonjour World", (Object)this.cache.get((Object)1));
        Assert.assertEquals((long)(++nWrite), (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        previousValue = (String)this.cache.getAndReplace((Object)1, (Object)"Hello World");
        Assert.assertEquals((Object)"Bonjour World", (Object)previousValue);
        Assert.assertEquals((Object)this.cache.get((Object)1), (Object)this.cacheWriter.get((Object)1));
        Assert.assertEquals((Object)previousValue, (Object)"Bonjour World");
        Assert.assertEquals((long)(++nWrite), (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        Assert.assertTrue((boolean)this.cacheWriter.hasWritten((Object)1));
        Assert.assertEquals((Object)"Hello World", (Object)this.cacheWriter.get((Object)1));
    }

    @Test
    public void shouldWriteThroughUsingInvoke_setValue_CreateEntry() {
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        this.cache.invoke((Object)1, (EntryProcessor)new SetEntryProcessor((Object)"Gudday World"), new Object[0]);
        Assert.assertEquals((long)1L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        Assert.assertTrue((boolean)this.cacheWriter.hasWritten((Object)1));
        Assert.assertEquals((Object)"Gudday World", (Object)this.cacheWriter.get((Object)1));
    }

    @Test
    public void shouldWriteThroughUsingInvokeAll_setValue_CreateEntry() {
        String VALUE_PREFIX = "value_";
        int NUM_KEYS = 10;
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        HashSet<Integer> keys = new HashSet<Integer>();
        for (int key = 1; key <= 10; ++key) {
            keys.add(key);
        }
        this.cache.invokeAll(keys, (EntryProcessor)new SetEntryWithComputedValueProcessor("value_", ""), new Object[0]);
        Assert.assertEquals((long)10L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        for (Integer key : keys) {
            String computedValue = "value_" + key;
            Assert.assertTrue((boolean)this.cacheWriter.hasWritten((Object)key));
            Assert.assertEquals((Object)computedValue, (Object)this.cacheWriter.get((Object)key));
            Assert.assertEquals((Object)computedValue, (Object)this.cache.get((Object)key));
        }
    }

    @Test
    public void shouldWriteThroughUsingInvoke_setValue_UpdateEntry() {
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        this.cache.put((Object)1, (Object)"Gudday World");
        this.cache.invoke((Object)1, (EntryProcessor)new SetEntryProcessor((Object)"Hello World"), new Object[0]);
        Assert.assertEquals((long)2L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        Assert.assertTrue((boolean)this.cacheWriter.hasWritten((Object)1));
        Assert.assertEquals((Object)"Hello World", (Object)this.cacheWriter.get((Object)1));
    }

    @Test
    public void shouldWriteThroughUsingInvokeAll_setValue_UpdateEntry() {
        String VALUE_PREFIX_ORIGINAL = "value_";
        String VALUE_PREFIX_UPDATED = "updateValue_";
        int NUMBER_OF_KEYS = 10;
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        HashSet<Integer> keys = new HashSet<Integer>();
        for (int key = 1; key <= 10; ++key) {
            keys.add(key);
            this.cache.put((Object)key, (Object)("value_" + key));
        }
        Assert.assertEquals((long)10L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        this.cache.invokeAll(keys, (EntryProcessor)new SetEntryWithComputedValueProcessor("updateValue_", ""), new Object[0]);
        Assert.assertEquals((long)20L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        for (Integer key : keys) {
            String computedValue = "updateValue_" + key;
            Assert.assertTrue((boolean)this.cacheWriter.hasWritten((Object)key));
            Assert.assertEquals((Object)computedValue, (Object)this.cacheWriter.get((Object)key));
            Assert.assertEquals((Object)computedValue, (Object)this.cache.get((Object)key));
        }
    }

    @Test
    public void shouldWriteThroughUsingInvoke_remove() {
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        this.cache.put((Object)1, (Object)"Gudday World");
        this.cache.invoke((Object)1, (EntryProcessor)new RemoveEntryProcessor(true), new Object[0]);
        Assert.assertEquals((long)1L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)1L, (long)this.cacheWriter.getDeleteCount());
        Assert.assertFalse((boolean)this.cacheWriter.hasWritten((Object)1));
    }

    @Test
    public void shouldWriteThroughUsingInvokeAll_setValue_RemoveEntry() {
        String VALUE_PREFIX = "value_";
        int NUM_KEYS = 10;
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        HashSet<Integer> keys = new HashSet<Integer>();
        for (int key = 1; key <= 10; ++key) {
            keys.add(key);
            this.cache.put((Object)key, (Object)("value_" + key));
        }
        Assert.assertEquals((long)10L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        this.cache.invokeAll(keys, (EntryProcessor)new RemoveEntryProcessor(true), new Object[0]);
        Assert.assertEquals((long)10L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)10L, (long)this.cacheWriter.getDeleteCount());
        for (Integer key : keys) {
            Assert.assertFalse((boolean)this.cacheWriter.hasWritten((Object)key));
            Assert.assertEquals(null, (Object)this.cacheWriter.get((Object)key));
            Assert.assertEquals(null, (Object)this.cache.get((Object)key));
        }
    }

    @Test
    public void shouldWriteThroughUsingInvoke_remove_nonExistingEntry() {
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        this.cache.invoke((Object)1, (EntryProcessor)new RemoveEntryProcessor(), new Object[0]);
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)1L, (long)this.cacheWriter.getDeleteCount());
        Assert.assertFalse((boolean)this.cacheWriter.hasWritten((Object)1));
    }

    @Test
    public void shouldWriteThroughUsingInvoke_remove_createEntry() {
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        this.cache.put((Object)1, (Object)"Gudday World");
        EntryProcessor[] processors = new EntryProcessor[]{new RemoveEntryProcessor(true), new AssertNotPresentEntryProcessor(null), new SetEntryProcessor((Object)"After remove")};
        this.cache.invoke((Object)1, (EntryProcessor)new CombineEntryProcessor(processors), new Object[0]);
        Assert.assertEquals((long)2L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        Assert.assertTrue((boolean)this.cacheWriter.hasWritten((Object)1));
    }

    @Test
    public void shouldWriteThroughUsingInvoke_setValue_CreateEntryThenRemove() {
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        EntryProcessor[] processors = new EntryProcessor[]{new AssertNotPresentEntryProcessor(null), new SetEntryProcessor((Object)"Gudday World"), new RemoveEntryProcessor(true)};
        this.cache.invoke((Object)1, (EntryProcessor)new CombineEntryProcessor(processors), new Object[0]);
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        Assert.assertTrue((!this.cacheWriter.hasWritten((Object)1) ? 1 : 0) != 0);
        Assert.assertTrue((this.cache.get((Object)1) == null ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.cache.containsKey((Object)1));
    }

    @Test
    public void shouldWriteThroughUsingInvoke_setValue_CreateEntryGetValue() {
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        EntryProcessor[] processors = new EntryProcessor[]{new AssertNotPresentEntryProcessor(null), new SetEntryProcessor((Object)"Gudday World")};
        Object[] result = (Object[])this.cache.invoke((Object)1, (EntryProcessor)new CombineEntryProcessor(processors), new Object[0]);
        Assert.assertEquals((Object)"Gudday World", (Object)result[1]);
        Assert.assertEquals((Object)this.cache.get((Object)1), (Object)result[1]);
        Assert.assertEquals((Object)this.cache.get((Object)1), (Object)this.cacheWriter.get((Object)1));
        Assert.assertEquals((long)1L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        Assert.assertTrue((boolean)this.cacheWriter.hasWritten((Object)1));
        Assert.assertEquals((Object)"Gudday World", (Object)this.cacheWriter.get((Object)1));
    }

    @Test
    public void shouldNotWriteThroughUsingIterator() {
        String VALUE_PREFIX = "value_";
        int NUMBER_OF_KEYS = 10;
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        HashSet<Integer> keys = new HashSet<Integer>();
        for (int aKey = 1; aKey <= 10; ++aKey) {
            keys.add(aKey);
            this.cache.put((Object)aKey, (Object)("value_" + aKey));
        }
        Assert.assertEquals((long)10L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        int i = 0;
        for (Cache.Entry entry : this.cache) {
            ++i;
            Assert.assertEquals((Object)entry.getValue(), (Object)this.cacheWriter.get(entry.getKey()));
        }
        Assert.assertEquals((long)10L, (long)i);
        Assert.assertEquals((long)10L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
    }

    @Test
    public void shouldNotPutWhenWriteThroughFails() {
        this.cacheWriterServer.setCacheWriter((CacheWriter)new FailingCacheWriter());
        try {
            this.cache.put((Object)1, (Object)"Gudday World");
            Assert.assertTrue((String)"expected exception on write-through", (boolean)false);
        }
        catch (CacheWriterException cacheWriterException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)this.cache.containsKey((Object)1));
    }

    @Test
    public void shouldWriteThoughUsingPutSingleEntry() {
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        this.cache.put((Object)1, (Object)"Gudday World");
        Assert.assertEquals((long)1L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        Assert.assertTrue((boolean)this.cacheWriter.hasWritten((Object)1));
        Assert.assertEquals((Object)"Gudday World", (Object)this.cacheWriter.get((Object)1));
    }

    @Test
    public void shouldWriteThroughUsingPutSingleEntryMultipleTimes() {
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        this.cache.put((Object)1, (Object)"Gudday World");
        this.cache.put((Object)1, (Object)"Bonjour World");
        this.cache.put((Object)1, (Object)"Hello World");
        Assert.assertEquals((long)3L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        Assert.assertTrue((boolean)this.cacheWriter.hasWritten((Object)1));
        Assert.assertEquals((Object)"Hello World", (Object)this.cacheWriter.get((Object)1));
    }

    @Test
    public void shouldWriteThroughUsingPutOfDifferentEntries() {
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        this.cache.put((Object)1, (Object)"Gudday World");
        this.cache.put((Object)2, (Object)"Bonjour World");
        this.cache.put((Object)3, (Object)"Hello World");
        Assert.assertEquals((long)3L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        Assert.assertTrue((boolean)this.cacheWriter.hasWritten((Object)1));
        Assert.assertEquals((Object)"Gudday World", (Object)this.cacheWriter.get((Object)1));
        Assert.assertTrue((boolean)this.cacheWriter.hasWritten((Object)2));
        Assert.assertEquals((Object)"Bonjour World", (Object)this.cacheWriter.get((Object)2));
        Assert.assertTrue((boolean)this.cacheWriter.hasWritten((Object)3));
        Assert.assertEquals((Object)"Hello World", (Object)this.cacheWriter.get((Object)3));
    }

    @Test
    public void shouldWriteThoughUsingPutAll() {
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "Gudday World");
        map.put(2, "Bonjour World");
        map.put(3, "Hello World");
        this.cache.putAll(map);
        Assert.assertEquals((long)3L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        for (Integer key : map.keySet()) {
            Assert.assertTrue((boolean)this.cacheWriter.hasWritten((Object)key));
            Assert.assertTrue((boolean)this.cache.containsKey((Object)key));
            Assert.assertEquals((Object)this.cache.get((Object)key), (Object)this.cacheWriter.get((Object)key));
            Assert.assertEquals(map.get(key), (Object)this.cache.get((Object)key));
        }
        map.put(4, "Hola World");
        this.cache.putAll(map);
        Assert.assertEquals((long)7L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        for (Integer key : map.keySet()) {
            Assert.assertTrue((boolean)this.cacheWriter.hasWritten((Object)key));
            Assert.assertEquals(map.get(key), (Object)this.cacheWriter.get((Object)key));
            Assert.assertTrue((boolean)this.cache.containsKey((Object)key));
            Assert.assertEquals(map.get(key), (Object)this.cache.get((Object)key));
        }
    }

    @Test
    public void shouldWriteThoughUsingPutAll_partialSuccess() {
        this.cacheWriter = new BatchPartialSuccessRecordingClassWriter(3, 100);
        this.cacheWriterServer.setCacheWriter(this.cacheWriter);
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "Gudday World");
        map.put(2, "Bonjour World");
        map.put(3, "Hello World");
        map.put(4, "Ciao World");
        try {
            this.cache.putAll(map);
            Assert.assertTrue((String)"expected CacheWriterException to be thrown for BatchPartialSuccessRecordingClassWriter", (boolean)false);
        }
        catch (CacheWriterException cacheWriterException) {
            // empty catch block
        }
        int numSuccess = 0;
        int numFailure = 0;
        for (Integer key : map.keySet()) {
            if (this.cacheWriter.hasWritten((Object)key)) {
                Assert.assertTrue((boolean)this.cache.containsKey((Object)key));
                Assert.assertEquals(map.get(key), (Object)this.cacheWriter.get((Object)key));
                Assert.assertEquals(map.get(key), (Object)this.cache.get((Object)key));
                ++numSuccess;
            } else {
                Assert.assertFalse((boolean)this.cache.containsKey((Object)key));
                Assert.assertFalse((boolean)this.cacheWriter.hasWritten((Object)key));
                Assert.assertEquals((Object)this.cache.get((Object)key), (Object)this.cacheWriter.get((Object)key));
                ++numFailure;
            }
            Assert.assertEquals((Object)this.cache.get((Object)key), (Object)this.cacheWriter.get((Object)key));
        }
        Assert.assertEquals((long)(numSuccess + numFailure), (long)map.size());
        Assert.assertEquals((long)numSuccess, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
    }

    @Test
    public void shouldWriteThoughUsingPutIfAbsent_SingleEntryMultipleTimes() {
        int nWrite = 0;
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        boolean result = this.cache.putIfAbsent((Object)1, (Object)"Gudday World");
        Assert.assertTrue((boolean)result);
        result = this.cache.putIfAbsent((Object)1, (Object)"Bonjour World");
        Assert.assertFalse((boolean)result);
        result = this.cache.putIfAbsent((Object)1, (Object)"Hello World");
        Assert.assertFalse((boolean)result);
        Assert.assertEquals((long)(++nWrite), (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        Assert.assertTrue((boolean)this.cacheWriter.hasWritten((Object)1));
        Assert.assertEquals((Object)"Gudday World", (Object)this.cacheWriter.get((Object)1));
    }

    @Test
    public void shouldWriteThroughRemoveNonexistentKey() {
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        boolean result = this.cache.remove((Object)1);
        Assert.assertFalse((boolean)result);
        Assert.assertEquals((long)1L, (long)this.cacheWriter.getDeleteCount());
    }

    @Test
    public void shouldWriteThroughRemove_SingleEntry() {
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        this.cache.put((Object)1, (Object)"Gudday World");
        Assert.assertEquals((long)1L, (long)this.cacheWriter.getWriteCount());
        boolean result = this.cache.remove((Object)1);
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)1L, (long)this.cacheWriter.getDeleteCount());
        Assert.assertFalse((boolean)this.cacheWriter.hasWritten((Object)1));
    }

    @Test
    public void shouldNotRemoveWhenWriteThroughFails() {
        this.cache.put((Object)1, (Object)"Gudday World");
        Assert.assertTrue((boolean)this.cache.containsKey((Object)1));
        this.cacheWriterServer.setCacheWriter((CacheWriter)new FailingCacheWriter());
        try {
            this.cache.remove((Object)1);
            Assert.assertTrue((String)"expected exception on write-through", (boolean)false);
        }
        catch (CacheWriterException cacheWriterException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.cache.containsKey((Object)1));
    }

    @Test
    public void shouldWriteThroughRemove_SingleEntryMultipleTimes() {
        int nDelete = 0;
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        this.cache.put((Object)1, (Object)"Gudday World");
        boolean result = this.cache.remove((Object)1);
        Assert.assertTrue((boolean)result);
        ++nDelete;
        result = this.cache.remove((Object)1);
        Assert.assertFalse((boolean)result);
        ++nDelete;
        result = this.cache.remove((Object)1);
        Assert.assertFalse((boolean)result);
        Assert.assertEquals((long)1L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)(++nDelete), (long)this.cacheWriter.getDeleteCount());
    }

    @Test
    public void shouldWriteThroughRemove_SpecificEntry() {
        int nDelete = 0;
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)nDelete, (long)this.cacheWriter.getDeleteCount());
        this.cache.put((Object)1, (Object)"Gudday World");
        boolean result = this.cache.remove((Object)1, (Object)"Hello World");
        Assert.assertFalse((boolean)result);
        Assert.assertEquals((long)nDelete, (long)this.cacheWriter.getDeleteCount());
        result = this.cache.remove((Object)1, (Object)"Gudday World");
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)(++nDelete), (long)this.cacheWriter.getDeleteCount());
        result = this.cache.remove((Object)1, (Object)"Gudday World");
        Assert.assertFalse((boolean)result);
        Assert.assertEquals((long)nDelete, (long)this.cacheWriter.getDeleteCount());
        Assert.assertEquals((long)1L, (long)this.cacheWriter.getWriteCount());
    }

    @Test
    public void shouldWriteThroughCacheIteratorRemove() {
        int nDelete = 0;
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        this.cache.getAndPut((Object)1, (Object)"Gudday World");
        this.cache.getAndPut((Object)2, (Object)"Bonjour World");
        this.cache.getAndPut((Object)3, (Object)"Hello World");
        Iterator iterator = this.cache.iterator();
        iterator.next();
        iterator.remove();
        ++nDelete;
        iterator.next();
        iterator.next();
        iterator.remove();
        Assert.assertEquals((long)3L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)(++nDelete), (long)this.cacheWriter.getDeleteCount());
    }

    @Test
    public void shouldWriteThroughRemoveAll() {
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "Gudday World");
        map.put(2, "Bonjour World");
        map.put(3, "Hello World");
        this.cache.putAll(map);
        Assert.assertEquals((long)3L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        for (Integer key : map.keySet()) {
            Assert.assertTrue((boolean)this.cacheWriter.hasWritten((Object)key));
            Assert.assertEquals(map.get(key), (Object)this.cacheWriter.get((Object)key));
            Assert.assertTrue((boolean)this.cache.containsKey((Object)key));
            Assert.assertEquals(map.get(key), (Object)this.cache.get((Object)key));
        }
        this.cache.removeAll();
        Assert.assertEquals((long)3L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)3L, (long)this.cacheWriter.getDeleteCount());
        for (Integer key : map.keySet()) {
            Assert.assertFalse((boolean)this.cacheWriter.hasWritten((Object)key));
            Assert.assertFalse((boolean)this.cache.containsKey((Object)key));
        }
        this.cache.removeAll();
        Assert.assertEquals((long)3L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)3L, (long)this.cacheWriter.getDeleteCount());
        for (Integer key : map.keySet()) {
            Assert.assertFalse((boolean)this.cacheWriter.hasWritten((Object)key));
            Assert.assertFalse((boolean)this.cache.containsKey((Object)key));
        }
        map.put(4, "Hola World");
        this.cache.putAll(map);
        Assert.assertEquals((long)7L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)3L, (long)this.cacheWriter.getDeleteCount());
        for (Integer key : map.keySet()) {
            Assert.assertTrue((boolean)this.cacheWriter.hasWritten((Object)key));
            Assert.assertEquals(map.get(key), (Object)this.cacheWriter.get((Object)key));
            Assert.assertTrue((boolean)this.cache.containsKey((Object)key));
            Assert.assertEquals(map.get(key), (Object)this.cache.get((Object)key));
        }
    }

    @Test
    public void shouldWriteThroughRemoveAll_partialSuccess() {
        this.cacheWriter = new BatchPartialSuccessRecordingClassWriter(100, 3);
        this.cacheWriterServer.setCacheWriter(this.cacheWriter);
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "Gudday World");
        map.put(2, "Bonjour World");
        map.put(3, "Hello World");
        this.cache.putAll(map);
        Assert.assertEquals((long)3L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        for (Integer key : map.keySet()) {
            Assert.assertTrue((boolean)this.cacheWriter.hasWritten((Object)key));
            Assert.assertEquals(map.get(key), (Object)this.cacheWriter.get((Object)key));
            Assert.assertTrue((boolean)this.cache.containsKey((Object)key));
            Assert.assertEquals(map.get(key), (Object)this.cache.get((Object)key));
        }
        try {
            this.cache.removeAll();
            Assert.assertTrue((String)"expected CacheWriterException to be thrown for BatchPartialSuccessRecordingClassWriter", (boolean)false);
        }
        catch (CacheWriterException cacheWriterException) {
            // empty catch block
        }
        int numSuccess = 0;
        int numFailure = 0;
        for (Integer key : map.keySet()) {
            if (this.cacheWriter.hasWritten((Object)key)) {
                Assert.assertTrue((boolean)this.cache.containsKey((Object)key));
                Assert.assertEquals(map.get(key), (Object)this.cacheWriter.get((Object)key));
                Assert.assertEquals(map.get(key), (Object)this.cache.get((Object)key));
                ++numFailure;
            } else {
                Assert.assertFalse((boolean)this.cache.containsKey((Object)key));
                ++numSuccess;
            }
            Assert.assertEquals((Object)this.cache.get((Object)key), (Object)this.cacheWriter.get((Object)key));
        }
        Assert.assertEquals((long)(numSuccess + numFailure), (long)map.size());
        Assert.assertEquals((long)3L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)numSuccess, (long)this.cacheWriter.getDeleteCount());
    }

    @Test
    public void shouldUseWriteThroughRemoveAllSpecific() {
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "Gudday World");
        map.put(2, "Bonjour World");
        map.put(3, "Hello World");
        map.put(4, "Hola World");
        this.cache.putAll(map);
        Assert.assertEquals((long)4L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        for (Integer key : map.keySet()) {
            Assert.assertTrue((boolean)this.cacheWriter.hasWritten((Object)key));
            Assert.assertEquals(map.get(key), (Object)this.cacheWriter.get((Object)key));
            Assert.assertTrue((boolean)this.cache.containsKey((Object)key));
            Assert.assertEquals(map.get(key), (Object)this.cache.get((Object)key));
        }
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(1);
        set.add(4);
        this.cache.removeAll(set);
        Assert.assertEquals((long)4L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)2L, (long)this.cacheWriter.getDeleteCount());
        for (Integer key : set) {
            Assert.assertFalse((boolean)this.cacheWriter.hasWritten((Object)key));
            Assert.assertFalse((boolean)this.cache.containsKey((Object)key));
        }
        this.cache.put((Object)4, (Object)"Howdy World");
        Assert.assertEquals((long)5L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)2L, (long)this.cacheWriter.getDeleteCount());
        set.clear();
        set.add(2);
        this.cache.removeAll(set);
        Assert.assertEquals((long)3L, (long)this.cacheWriter.getDeleteCount());
        Assert.assertTrue((boolean)this.cacheWriter.hasWritten((Object)3));
        Assert.assertTrue((boolean)this.cache.containsKey((Object)3));
        Assert.assertTrue((boolean)this.cacheWriter.hasWritten((Object)4));
        Assert.assertTrue((boolean)this.cache.containsKey((Object)4));
    }

    @Test
    public void shouldWriteThroughRemoveAllSpecific_partialSuccess() {
        this.cacheWriter = new BatchPartialSuccessRecordingClassWriter(100, 3);
        this.cacheWriterServer.setCacheWriter(this.cacheWriter);
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        HashMap<Integer, String> entriesAdded = new HashMap<Integer, String>();
        entriesAdded.put(1, "Gudday World");
        entriesAdded.put(2, "Bonjour World");
        entriesAdded.put(3, "Hello World");
        entriesAdded.put(4, "Hola World");
        entriesAdded.put(5, "Ciao World");
        this.cache.putAll(entriesAdded);
        Assert.assertEquals((long)5L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        for (Integer key : entriesAdded.keySet()) {
            Assert.assertTrue((boolean)this.cacheWriter.hasWritten((Object)key));
            Assert.assertEquals(entriesAdded.get(key), (Object)this.cacheWriter.get((Object)key));
            Assert.assertTrue((boolean)this.cache.containsKey((Object)key));
            Assert.assertEquals(entriesAdded.get(key), (Object)this.cache.get((Object)key));
        }
        HashSet<Integer> keysToRemove = new HashSet<Integer>();
        keysToRemove.add(1);
        keysToRemove.add(2);
        keysToRemove.add(3);
        keysToRemove.add(4);
        try {
            this.cache.removeAll(keysToRemove);
            Assert.assertTrue((String)"expected CacheWriterException to be thrown for BatchPartialSuccessRecordingClassWriter", (boolean)false);
        }
        catch (CacheWriterException key) {
            // empty catch block
        }
        int numSuccess = 0;
        int numFailure = 0;
        for (Integer key : entriesAdded.keySet()) {
            if (this.cacheWriter.hasWritten((Object)key)) {
                Assert.assertTrue((boolean)this.cache.containsKey((Object)key));
                Assert.assertEquals(entriesAdded.get(key), (Object)this.cacheWriter.get((Object)key));
                Assert.assertEquals(entriesAdded.get(key), (Object)this.cache.get((Object)key));
                ++numFailure;
            } else {
                Assert.assertFalse((boolean)this.cache.containsKey((Object)key));
                ++numSuccess;
            }
            Assert.assertEquals((Object)this.cache.get((Object)key), (Object)this.cacheWriter.get((Object)key));
        }
        Assert.assertEquals((long)(numSuccess + numFailure), (long)entriesAdded.size());
        Assert.assertEquals((long)5L, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)numSuccess, (long)this.cacheWriter.getDeleteCount());
    }

    @Test
    public void shouldNotWriteThroughReplaceNonExistentKey() {
        int nWrites = 0;
        Assert.assertEquals((long)nWrites, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        boolean result = this.cache.replace((Object)1, (Object)"Gudday World");
        Assert.assertFalse((boolean)result);
        Assert.assertEquals((long)nWrites, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
    }

    @Test
    public void shouldWriteThroughReplaceExisting_SingleEntryMultipleTimes() {
        int nWrites = 0;
        Assert.assertEquals((long)nWrites, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        boolean result = this.cache.replace((Object)1, (Object)"Gudday World");
        Assert.assertFalse((boolean)result);
        result = this.cache.putIfAbsent((Object)1, (Object)"Gudday World");
        Assert.assertTrue((boolean)result);
        ++nWrites;
        result = this.cache.replace((Object)1, (Object)"Bonjour World");
        Assert.assertTrue((boolean)result);
        ++nWrites;
        result = this.cache.replace((Object)1, (Object)"Hello World");
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)(++nWrites), (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        Assert.assertTrue((boolean)this.cacheWriter.hasWritten((Object)1));
        Assert.assertEquals((Object)"Hello World", (Object)this.cacheWriter.get((Object)1));
        Assert.assertEquals((Object)this.cache.get((Object)1), (Object)this.cacheWriter.get((Object)1));
    }

    @Test
    public void shouldNotUseWriteThroughReplaceDoesNotMatch() {
        int nWriter = 0;
        Assert.assertEquals((long)nWriter, (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        boolean result = this.cache.putIfAbsent((Object)1, (Object)"Gudday World");
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)1L, (long)this.cacheWriter.getWriteCount());
        result = this.cache.replace((Object)1, (Object)"Bonjour World", (Object)"Hello World");
        Assert.assertFalse((boolean)result);
        Assert.assertFalse((boolean)"Hello World".equals(this.cache.get((Object)1)));
        Assert.assertEquals((long)(++nWriter), (long)this.cacheWriter.getWriteCount());
        Assert.assertEquals((long)0L, (long)this.cacheWriter.getDeleteCount());
        Assert.assertTrue((boolean)this.cacheWriter.hasWritten((Object)1));
        Assert.assertEquals((Object)this.cache.get((Object)1), (Object)this.cacheWriter.get((Object)1));
    }

    @Test
    public void shouldWrapWriterExceptions() throws IOException {
        this.cleanup();
        this.cacheWriter = new FailingCacheWriter();
        this.cacheWriterServer = new CacheWriterServer(10000, this.cacheWriter);
        this.cacheWriterServer.open();
        this.cacheManager = Caching.getCachingProvider().getCacheManager();
        CacheWriterClient theCacheWriter = new CacheWriterClient(this.cacheWriterServer.getInetAddress(), this.cacheWriterServer.getPort());
        MutableConfiguration configuration = new MutableConfiguration();
        configuration.setTypes(Integer.class, String.class);
        configuration.setCacheWriterFactory(FactoryBuilder.factoryOf((Serializable)theCacheWriter));
        configuration.setWriteThrough(true);
        this.getCacheManager().createCache("failing-cache-writer-test", (Configuration)configuration);
        this.cache = this.getCacheManager().getCache("failing-cache-writer-test", Integer.class, String.class);
        try {
            this.cache.put((Object)12, (Object)"Tonto");
            Assert.fail();
        }
        catch (CacheWriterException cacheWriterException) {
            // empty catch block
        }
        try {
            HashMap<Integer, String> map = new HashMap<Integer, String>();
            map.put(12, "Tonto");
            this.cache.putAll(map);
            Assert.fail();
        }
        catch (CacheWriterException map) {
            // empty catch block
        }
        try {
            this.cache.remove((Object)12);
            Assert.fail();
        }
        catch (CacheWriterException map) {
            // empty catch block
        }
        try {
            HashSet<Integer> set = new HashSet<Integer>();
            set.add(12);
            this.cache.removeAll(set);
            Assert.fail();
        }
        catch (CacheWriterException cacheWriterException) {
            // empty catch block
        }
        this.cache.removeAll();
    }

    public static class Entry<K, V>
    implements Cache.Entry<K, V> {
        private K key;
        private V value;

        public Entry(K k, V v) {
            this.key = k;
            this.value = v;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public <T> T unwrap(Class<T> clazz) {
            throw new UnsupportedOperationException("not implemented");
        }
    }
}

