/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.processor;

import java.util.HashSet;
import java.util.Map;
import javax.cache.CacheException;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import org.jsr107.tck.processor.AssertNotPresentEntryProcessor;
import org.jsr107.tck.processor.CombineEntryProcessor;
import org.jsr107.tck.processor.GetEntryProcessor;
import org.jsr107.tck.processor.MultiArgumentHandlingEntryProcessor;
import org.jsr107.tck.processor.NoOpEntryProcessor;
import org.jsr107.tck.processor.RemoveEntryProcessor;
import org.jsr107.tck.processor.ReplaceEntryProcessor;
import org.jsr107.tck.processor.SetEntryProcessor;
import org.jsr107.tck.processor.SetValueCreateEntryReturnDifferentTypeEntryProcessor;
import org.jsr107.tck.processor.ThrowExceptionEntryProcessor;
import org.jsr107.tck.testutil.CacheTestSupport;
import org.jsr107.tck.testutil.ExcludeListExcluder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class CacheInvokeTest
extends CacheTestSupport<Integer, String> {
    @Rule
    public ExcludeListExcluder rule = new ExcludeListExcluder(CacheInvokeTest.class);

    @Before
    public void moreSetUp() {
        this.cache = this.getCacheManager().getCache(this.getTestCacheName(), Integer.class, String.class);
    }

    @Override
    protected MutableConfiguration<Integer, String> newMutableConfiguration() {
        return new MutableConfiguration().setTypes(Integer.class, String.class);
    }

    @Test
    public void nullKey() {
        try {
            this.cache.invoke(null, (EntryProcessor)new ThrowExceptionEntryProcessor(UnsupportedOperationException.class), new Object[0]);
            Assert.fail((String)"null key");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void nullProcessor() {
        try {
            this.cache.invoke((Object)123, null, new Object[0]);
            Assert.fail((String)"null key");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void nullGetValue() {
        String result = (String)this.cache.invoke((Object)123, (EntryProcessor)new GetEntryProcessor(), new Object[0]);
        junit.framework.Assert.assertNull((Object)result);
    }

    @Test(expected=EntryProcessorException.class)
    public void setValueToNull() {
        this.cache.invoke((Object)123, (EntryProcessor)new SetEntryProcessor(null), new Object[0]);
    }

    @Test(expected=NullPointerException.class)
    public void invokeAllNullKeys() {
        this.cache.invokeAll(null, (EntryProcessor)new NoOpEntryProcessor(), new Object[0]);
    }

    @Test(expected=EntryProcessorException.class)
    public void invokeAllEntryProcessorException() {
        HashSet<Integer> keys = new HashSet<Integer>();
        keys.add(123);
        Map resultMap = this.cache.invokeAll(keys, (EntryProcessor)new ThrowExceptionEntryProcessor(IllegalStateException.class), new Object[0]);
        ((EntryProcessorResult)resultMap.get(123)).get();
    }

    @Test
    public void invokeAllEntryProcessorReturnsNullResult() {
        HashSet<Integer> keys = new HashSet<Integer>();
        keys.add(123);
        Map resultMap = this.cache.invokeAll(keys, (EntryProcessor)new SetValueCreateEntryReturnDifferentTypeEntryProcessor(null, (Object)"newValue"), new Object[0]);
        Assert.assertTrue((resultMap != null && resultMap.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void invokeAllgetResultFromMap() {
        HashSet<Integer> keys = new HashSet<Integer>();
        keys.add(123);
        Map resultMap = this.cache.invokeAll(keys, (EntryProcessor)new SetEntryProcessor((Object)"aValue"), new Object[0]);
        Assert.assertTrue((resultMap != null && resultMap.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"aValue", (Object)((EntryProcessorResult)resultMap.get(123)).get());
    }

    @Test
    public void close() {
        this.cache.close();
        try {
            this.cache.invoke((Object)123, (EntryProcessor)new ThrowExceptionEntryProcessor(UnsupportedOperationException.class), new Object[0]);
            Assert.fail((String)"null key");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testProcessorExceptionIsWrapped() {
        try {
            this.cache.invoke((Object)123, (EntryProcessor)new ThrowExceptionEntryProcessor(UnsupportedOperationException.class), new Object[0]);
            Assert.fail();
        }
        catch (EntryProcessorException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof RuntimeException));
        }
    }

    @Test
    public void testProcessorEmptyExceptionIsWrapped() {
        try {
            this.cache.invoke((Object)123, (EntryProcessor)new ThrowExceptionEntryProcessor(UnsupportedOperationException.class), new Object[0]);
            Assert.fail();
        }
        catch (EntryProcessorException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof RuntimeException));
        }
    }

    @Test
    public void noValueNoMutation() {
        Integer key = 123;
        Integer ret = 456;
        Assert.assertEquals((Object)ret, (Object)this.cache.invoke((Object)key, (EntryProcessor)new AssertNotPresentEntryProcessor((Object)ret), new Object[0]));
        Assert.assertFalse((boolean)this.cache.containsKey((Object)key));
    }

    @Test
    public void varArgumentsPassedIn() {
        Integer key = 123;
        Integer ret = 456;
        Assert.assertEquals((Object)ret, (Object)this.cache.invoke((Object)key, (EntryProcessor)new MultiArgumentHandlingEntryProcessor((Object)ret), new Object[]{"These", "are", "arguments", 1L}));
        Assert.assertFalse((boolean)this.cache.containsKey((Object)key));
    }

    @Test
    public void noValueSetValue() {
        Integer key = 123;
        Integer ret = 456;
        String value = "abc";
        Assert.assertEquals((Object)ret, (Object)this.cache.invoke((Object)key, (EntryProcessor)new SetValueCreateEntryReturnDifferentTypeEntryProcessor((Object)ret, (Object)"abc"), new Object[0]));
        Assert.assertEquals((Object)"abc", (Object)this.cache.get((Object)key));
    }

    @Test
    public void noValueException() {
        Integer key = 123;
        String setValue = "abc";
        EntryProcessor[] processors = new EntryProcessor[]{new AssertNotPresentEntryProcessor(null), new SetEntryProcessor((Object)"abc"), new ThrowExceptionEntryProcessor(IllegalAccessError.class)};
        try {
            this.cache.invoke((Object)key, (EntryProcessor)new CombineEntryProcessor(processors), new Object[0]);
            Assert.fail();
        }
        catch (CacheException e) {
            Throwable rootCause = CacheInvokeTest.getRootCause(e);
            Assert.assertTrue((String)("expected IllegalAccessError; observed " + rootCause), (boolean)(rootCause instanceof IllegalAccessError));
        }
        Assert.assertFalse((boolean)this.cache.containsKey((Object)key));
    }

    @Test(expected=NullPointerException.class)
    public void invokeAll_keys_null() {
        this.cache.invoke(null, null, new Object[0]);
    }

    @Test(expected=NullPointerException.class)
    public void invokeAll_nullProcessor() {
        HashSet<Integer> keys = new HashSet<Integer>();
        keys.add(123);
        this.cache.invokeAll(keys, null, new Object[0]);
    }

    @Test
    public void existingReplace() {
        Integer key = 123;
        String oldValue = "abc";
        String newValue = "def";
        this.cache.put((Object)key, (Object)"abc");
        Assert.assertEquals((Object)"abc", (Object)this.cache.invoke((Object)key, (EntryProcessor)new ReplaceEntryProcessor((Object)"abc", (Object)"def"), new Object[0]));
        Assert.assertEquals((Object)"def", (Object)this.cache.get((Object)key));
    }

    private static Throwable getRootCause(Throwable t) {
        if (t.getCause() == null) {
            return t;
        }
        return CacheInvokeTest.getRootCause(t.getCause());
    }

    @Test
    public void existingException() {
        Integer key = 123;
        String oldValue = "abc";
        String newValue = "def";
        this.cache.put((Object)key, (Object)"abc");
        EntryProcessor[] processors = new EntryProcessor[]{new ReplaceEntryProcessor((Object)"abc", (Object)"def"), new ThrowExceptionEntryProcessor(IllegalAccessError.class)};
        try {
            this.cache.invoke((Object)key, (EntryProcessor)new CombineEntryProcessor(processors), new Object[0]);
            Assert.fail();
        }
        catch (CacheException e) {
            Throwable rootCause = CacheInvokeTest.getRootCause(e);
            Assert.assertTrue((String)("expected IllegalAccessError; observed " + rootCause), (boolean)(rootCause instanceof IllegalAccessError));
        }
        Assert.assertEquals((Object)"abc", (Object)this.cache.get((Object)key));
    }

    @Test
    public void removeMissing() {
        Integer key = 123;
        String value = "aba";
        Integer ret = 456;
        EntryProcessor[] processors = new EntryProcessor[]{new AssertNotPresentEntryProcessor((Object)ret), new SetEntryProcessor((Object)"aba"), new RemoveEntryProcessor(true)};
        Object[] result = (Object[])this.cache.invoke((Object)key, (EntryProcessor)new CombineEntryProcessor(processors), new Object[0]);
        Assert.assertEquals((Object)ret, (Object)result[0]);
        Assert.assertFalse((boolean)this.cache.containsKey((Object)key));
    }

    @Test
    public void removeExisting() {
        Integer key = 123;
        String oldValue = "abc";
        this.cache.put((Object)key, (Object)"abc");
        Assert.assertEquals((Object)"abc", (Object)this.cache.invoke((Object)key, (EntryProcessor)new RemoveEntryProcessor(true), new Object[0]));
        Assert.assertFalse((boolean)this.cache.containsKey((Object)key));
    }

    @Test
    public void removeException() {
        Integer key = 123;
        String oldValue = "abc";
        this.cache.put((Object)key, (Object)"abc");
        try {
            this.cache.invoke((Object)key, (EntryProcessor)new ThrowExceptionEntryProcessor(IllegalAccessError.class), new Object[0]);
            Assert.fail();
        }
        catch (CacheException e) {
            Throwable t = CacheInvokeTest.getRootCause(e);
            Assert.assertTrue((String)("expected IllegalAccessError; observed " + t), (boolean)(t instanceof IllegalAccessError));
        }
        Assert.assertEquals((Object)"abc", (Object)this.cache.get((Object)key));
    }
}

