/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.spi;

import java.net.URI;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.spi.CachingProvider;
import org.jsr107.tck.testutil.ExcludeListExcluder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class CachingProviderClassLoaderTest {
    @Rule
    public ExcludeListExcluder rule = new ExcludeListExcluder(this.getClass());

    @Before
    public void startUp() {
        Caching.getCachingProvider().close();
    }

    @Test
    public void getCacheManagerSingleton() {
        CachingProvider provider = Caching.getCachingProvider();
        ClassLoader classLoader = Caching.getDefaultClassLoader();
        CacheManager manager = provider.getCacheManager();
        Assert.assertNotNull((Object)classLoader);
        Assert.assertNotNull((Object)manager);
        Assert.assertSame((Object)manager, (Object)provider.getCacheManager());
        Assert.assertSame((Object)manager, (Object)provider.getCacheManager(provider.getDefaultURI(), provider.getDefaultClassLoader()));
        MyClassLoader otherLoader = new MyClassLoader(classLoader);
        CachingProvider otherProvider = Caching.getCachingProvider((ClassLoader)otherLoader);
        CacheManager otherManager = otherProvider.getCacheManager();
        Assert.assertSame((Object)otherManager, (Object)otherProvider.getCacheManager());
        Assert.assertSame((Object)otherManager, (Object)otherProvider.getCacheManager(otherProvider.getDefaultURI(), otherProvider.getDefaultClassLoader()));
    }

    @Test
    public void getCacheManagerDefaultURI() {
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        CachingProvider provider = Caching.getCachingProvider((ClassLoader)contextLoader);
        CacheManager manager = provider.getCacheManager();
        Assert.assertEquals((Object)provider.getDefaultURI(), (Object)manager.getURI());
        MyClassLoader otherLoader = new MyClassLoader(contextLoader);
        CachingProvider otherProvider = Caching.getCachingProvider((ClassLoader)otherLoader);
        Assert.assertNotSame((Object)provider, (Object)otherProvider);
        CacheManager otherManager = otherProvider.getCacheManager();
        Assert.assertNotSame((Object)manager, (Object)otherManager);
        Assert.assertEquals((Object)otherProvider.getDefaultURI(), (Object)otherManager.getURI());
    }

    @Test
    public void getCacheManagerSameURI() {
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        CachingProvider provider = Caching.getCachingProvider((ClassLoader)contextLoader);
        URI uri = provider.getDefaultURI();
        CacheManager manager = provider.getCacheManager(uri, contextLoader);
        Assert.assertEquals((Object)uri, (Object)manager.getURI());
        MyClassLoader otherLoader = new MyClassLoader(contextLoader);
        CachingProvider otherProvider = Caching.getCachingProvider((ClassLoader)otherLoader);
        Assert.assertNotSame((Object)provider, (Object)otherProvider);
        CacheManager otherManager = otherProvider.getCacheManager(uri, contextLoader);
        Assert.assertNotSame((Object)manager, (Object)otherManager);
        Assert.assertEquals((Object)uri, (Object)otherManager.getURI());
    }

    @Test
    public void closeAllCacheManagers() throws Exception {
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        CachingProvider provider = Caching.getCachingProvider((ClassLoader)contextLoader);
        URI uri = provider.getDefaultURI();
        MyClassLoader loader1 = new MyClassLoader(contextLoader);
        CacheManager manager1 = provider.getCacheManager(uri, (ClassLoader)loader1);
        MyClassLoader loader2 = new MyClassLoader(contextLoader);
        CacheManager manager2 = provider.getCacheManager(uri, (ClassLoader)loader2);
        MyClassLoader loader3 = new MyClassLoader(contextLoader);
        CacheManager manager3 = provider.getCacheManager(uri, (ClassLoader)loader3);
        provider.close();
        Assert.assertNotSame((Object)manager1, (Object)provider.getCacheManager(uri, (ClassLoader)loader1));
        Assert.assertNotSame((Object)manager2, (Object)provider.getCacheManager(uri, (ClassLoader)loader2));
        Assert.assertNotSame((Object)manager3, (Object)provider.getCacheManager(uri, (ClassLoader)loader3));
    }

    @Test
    public void closeCacheManager() throws Exception {
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        CachingProvider provider = Caching.getCachingProvider((ClassLoader)contextLoader);
        URI uri = provider.getDefaultURI();
        MyClassLoader loader1 = new MyClassLoader(contextLoader);
        CacheManager manager1 = provider.getCacheManager(uri, (ClassLoader)loader1);
        MyClassLoader loader2 = new MyClassLoader(contextLoader);
        CacheManager manager2 = provider.getCacheManager(uri, (ClassLoader)loader2);
        MyClassLoader loader3 = new MyClassLoader(contextLoader);
        CacheManager manager3 = provider.getCacheManager(uri, (ClassLoader)loader3);
        provider.close(manager2.getURI(), (ClassLoader)loader2);
        Assert.assertSame((Object)manager1, (Object)provider.getCacheManager(uri, (ClassLoader)loader1));
        Assert.assertNotSame((Object)manager2, (Object)provider.getCacheManager(uri, (ClassLoader)loader2));
        Assert.assertSame((Object)manager3, (Object)provider.getCacheManager(uri, (ClassLoader)loader3));
    }

    @Test
    public void closeClassLoader() throws Exception {
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        CachingProvider provider = Caching.getCachingProvider((ClassLoader)contextLoader);
        URI uri = provider.getDefaultURI();
        MyClassLoader loader1 = new MyClassLoader(contextLoader);
        CacheManager manager1 = provider.getCacheManager(uri, (ClassLoader)loader1);
        MyClassLoader loader2 = new MyClassLoader(contextLoader);
        CacheManager manager2 = provider.getCacheManager(uri, (ClassLoader)loader2);
        MyClassLoader loader3 = new MyClassLoader(contextLoader);
        CacheManager manager3 = provider.getCacheManager(uri, (ClassLoader)loader3);
        provider.close(contextLoader);
        provider.close(provider.getDefaultURI(), contextLoader);
        provider.close(provider.getDefaultURI(), contextLoader);
        provider.close(provider.getDefaultURI(), contextLoader);
        Assert.assertSame((Object)manager1, (Object)provider.getCacheManager(uri, (ClassLoader)loader1));
        Assert.assertSame((Object)manager2, (Object)provider.getCacheManager(uri, (ClassLoader)loader2));
        Assert.assertSame((Object)manager3, (Object)provider.getCacheManager(uri, (ClassLoader)loader3));
    }

    private static class MyClassLoader
    extends ClassLoader {
        public MyClassLoader(ClassLoader parent) {
            super(parent);
        }
    }
}

