/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.lifecycle.LifecycleImpl;
import com.sun.faces.lifecycle.Phase;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.event.PhaseId;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifecycleFactoryImpl
extends LifecycleFactory {
    static final int FIRST_PHASE = PhaseId.RESTORE_VIEW.getOrdinal();
    static final int LAST_PHASE = PhaseId.RENDER_RESPONSE.getOrdinal();
    private static Logger logger = Util.getLogger("javax.enterprise.resource.webcontainer.jsf.lifecycle");
    protected HashMap<String, LifecycleWrapper> lifecycleMap = new HashMap();
    protected Object lock = null;

    public LifecycleFactoryImpl() {
        this.lifecycleMap.put("DEFAULT", new LifecycleWrapper(new LifecycleImpl(), false));
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Created Default Lifecycle");
        }
        this.lock = new Object();
    }

    boolean alreadyCreated(String lifecycleId) {
        LifecycleWrapper wrapper = this.lifecycleMap.get(lifecycleId);
        return null != wrapper && wrapper.created;
    }

    Lifecycle verifyRegisterArgs(String lifecycleId, int phaseId, Phase phase) {
        String message = null;
        LifecycleWrapper wrapper = null;
        Lifecycle result = null;
        Object[] params = new Object[]{lifecycleId};
        if (null == phase) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "lifecycleId"));
        }
        if (null == phase) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "phace"));
        }
        wrapper = this.lifecycleMap.get(lifecycleId);
        if (null == wrapper) {
            message = MessageUtils.getExceptionMessageString("com.sun.faces.LIFECYCLE_ID_NOT_FOUND", params);
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning(message);
            }
            throw new IllegalArgumentException(message);
        }
        result = wrapper.instance;
        assert (null != result);
        if (this.alreadyCreated(lifecycleId)) {
            message = MessageUtils.getExceptionMessageString("com.sun.faces.LIFECYCLE_ID_ALREADY_ADDED", params);
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning(message);
            }
            throw new IllegalStateException(message);
        }
        if (FIRST_PHASE > phaseId || phaseId > LAST_PHASE) {
            params = new Object[]{Integer.toString(phaseId)};
            message = MessageUtils.getExceptionMessageString("com.sun.faces.PHASE_ID_OUT_OF_BOUNDS", params);
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning(message);
            }
            throw new IllegalArgumentException(message);
        }
        return result;
    }

    public void addLifecycle(String lifecycleId, Lifecycle lifecycle) {
        if (lifecycleId == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "lifecycleId"));
        }
        if (lifecycle == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "lifecycle"));
        }
        if (null != this.lifecycleMap.get(lifecycleId)) {
            Object[] params = new Object[]{lifecycleId};
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.LIFECYCLE_ID_ALREADY_ADDED", params);
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning(MessageUtils.getExceptionMessageString("com.sun.faces.LIFECYCLE_ID_ALREADY_ADDED", params));
            }
            throw new IllegalArgumentException(message);
        }
        this.lifecycleMap.put(lifecycleId, new LifecycleWrapper(lifecycle, false));
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("addedLifecycle: " + lifecycleId + " " + lifecycle);
        }
    }

    public Lifecycle getLifecycle(String lifecycleId) throws FacesException {
        Lifecycle result = null;
        LifecycleWrapper wrapper = null;
        if (null == lifecycleId) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "lifecycleId"));
        }
        if (null == this.lifecycleMap.get(lifecycleId)) {
            Object[] params = new Object[]{lifecycleId};
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.CANT_CREATE_LIFECYCLE_ERROR", params);
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("LifecycleId " + lifecycleId + " does not exist");
            }
            throw new IllegalArgumentException(message);
        }
        wrapper = this.lifecycleMap.get(lifecycleId);
        result = wrapper.instance;
        wrapper.created = true;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("getLifecycle: " + lifecycleId + " " + result);
        }
        return result;
    }

    public Iterator<String> getLifecycleIds() {
        return this.lifecycleMap.keySet().iterator();
    }

    static class LifecycleWrapper {
        Lifecycle instance = null;
        boolean created = false;

        LifecycleWrapper(Lifecycle newInstance, boolean newCreated) {
            this.instance = newInstance;
            this.created = newCreated;
        }
    }
}

