/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jaxb.intros.handlers;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.xml.bind.annotation.XmlElement;
import org.jboss.jaxb.intros.ConfigurationException;
import org.jboss.jaxb.intros.configmodel.XmlElementIntro;
import org.jboss.jaxb.intros.handlers.ClassValue;

public class XmlElementHandler
implements InvocationHandler {
    private XmlElementIntro xmlElementIntro;

    private XmlElementHandler(XmlElementIntro xmlElementIntro) {
        this.xmlElementIntro = xmlElementIntro;
    }

    public static Annotation createProxy(XmlElementIntro xmlElementIntro) {
        return (Annotation)Proxy.newProxyInstance(XmlElementIntro.class.getClassLoader(), new Class[]{XmlElement.class, ClassValue.class}, (InvocationHandler)new XmlElementHandler(xmlElementIntro));
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals("getClassValue")) {
            methodName = (String)args[1];
        }
        if (methodName.equals("namespace")) {
            return this.xmlElementIntro.getNamespace();
        }
        if (methodName.equals("name")) {
            return this.xmlElementIntro.getName();
        }
        if (methodName.equals("nillable")) {
            return this.xmlElementIntro.isNillable();
        }
        if (methodName.equals("required")) {
            return this.xmlElementIntro.isRequired();
        }
        if (methodName.equals("defaultValue")) {
            String defaultVal = this.xmlElementIntro.getDefaultValue();
            return defaultVal != null ? defaultVal : "\u0000";
        }
        if (methodName.equals("type")) {
            if (this.xmlElementIntro.getType() != null) {
                try {
                    return Class.forName(this.xmlElementIntro.getType());
                }
                catch (ClassNotFoundException e) {
                    throw new ConfigurationException("Bad 'XmlElement.type' config value '" + this.xmlElementIntro.getType() + "' in JAXB Annotation Introduction config.  Class not found.");
                }
            }
            return XmlElement.DEFAULT.class;
        }
        if (methodName.equals("annotationType")) {
            return XmlElement.class;
        }
        return null;
    }
}

