<?xml version="1.0" encoding="UTF-8"?>
<!--
    This file was initially developed in the displaytag project - http://displaytag.sourceforge.net
    Original author of this file is Andy Pruitt
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:output method="html" encoding="UTF-8" />
    <xsl:template match="/">
        <document>
            <properties>
                <title>Tag reference</title>
            </properties>
            <body>
                <section>
                    <xsl:attribute name="name">
                        <xsl:choose>
                            <xsl:when test="taglib/display-name">
                                <xsl:value-of select="taglib/display-name" />
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="taglib/short-name|taglib/shortname" />
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:attribute>
                    <p>
                        <xsl:value-of select="taglib/description|taglib/info" />
                        This is version
                        <xsl:value-of select="taglib/tlib-version|taglib/tlibversion" />
                        .
                    </p>
                    <ul>
                        <xsl:for-each select="//tag">
                            <xsl:sort select="name" />
                            <li><!-- Showing only the first sentence -->
                                <a href="#{name}">
                                    <xsl:choose>
                                        <xsl:when
                                            test="description[ contains( translate(.,'ACDEPRT','acdeprt'),'deprecated')]">
                                            <em class="deprecated">
                                                <xsl:value-of select="name" />
                                            </em>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:value-of select="name" />
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </a>
                                <xsl:text>&#x20;</xsl:text>
                                <xsl:if test="not(contains(description,'.'))">
                                    <xsl:value-of select="description|info" />
                                </xsl:if>
                                <xsl:value-of select="substring-before(description,'.')" />
                                <xsl:value-of select="substring-before(info,'.')" />
                                .
                            </li>
                        </xsl:for-each>
                    </ul>
                    <p>
                        <em>
                            Required attributes are marked with a
                            <span style="color: red;">*</span>
                            .
                        </em>
                    </p>
                </section>
                <xsl:apply-templates select="//tag" />
            </body>
        </document>
    </xsl:template>
    <xsl:template match="tag">
        <section name="{name}">
            <p>
                <xsl:value-of select="description|info" />
            </p>
            <p>
                Can contain:
                <xsl:value-of select="body-content|bodycontent" />
            </p>
            <xsl:if test="example">
                <subsection name="Example">
                    <xsl:apply-templates select="example" />
                </subsection>
            </xsl:if>
            <xsl:if test="variable">
                <subsection name="Variables">
                    <table>
                        <thead>
                            <th>Name</th>
                            <th>Type</th>
                            <th>Scope</th>
                            <th>Description</th>
                        </thead>
                        <xsl:apply-templates select="variable">
                            <xsl:sort select="@name-given" />
                        </xsl:apply-templates>
                    </table>
                </subsection>
            </xsl:if>
            <subsection name="Attributes">
                <table>
                    <xsl:choose>
                        <xsl:when test="attribute">
                            <tr>
                                <th>Name</th>
                                <th>Description</th>
                                <xsl:if test="//type">
                                    <th>Type</th>
                                </xsl:if>
                            </tr>
                            <xsl:apply-templates select="attribute">
                                <xsl:sort
                                    select="description[ contains( translate(.,'ACDEPRT','acdeprt'),'deprecated')]"
                                    order="ascending" />
                                <xsl:sort select="required" order="descending" />
                                <xsl:sort select="name" />
                            </xsl:apply-templates>
                        </xsl:when>
                        <xsl:otherwise>
                            <tr>
                                <td>This tag has no attributes.</td>
                            </tr>
                        </xsl:otherwise>
                    </xsl:choose>
                </table>
            </subsection>
        </section>
    </xsl:template>
    <xsl:template match="attribute">
        <tr>
            <xsl:if test="'true'=required">
                <xsl:attribute name="class">required</xsl:attribute>
                <xsl:attribute name="title">Required</xsl:attribute>
            </xsl:if>
            <td>
                <a name="{preceding-sibling::name}_{name}" />
                <xsl:if test="'true'=required">
                    <span style="color: red;">*</span>
                </xsl:if>
                <xsl:choose>
                    <xsl:when test="description[ contains( translate(.,'ACDEPRT','acdeprt'),'deprecated')]">
                        <em class="deprecated">
                            <xsl:value-of select="name" />
                        </em>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="name" />
                    </xsl:otherwise>
                </xsl:choose>
            </td>
            <td>
                <xsl:value-of select="description|info" />
            </td>
            <xsl:if test="//type">
                <td>
                    <code>
                        <xsl:choose>
                            <xsl:when test="starts-with(type,'java.lang.')">
                                <xsl:value-of select="substring-after(type,'java.lang.')" />
                            </xsl:when>
                            <xsl:when test="type">
                                <xsl:value-of select="type" />
                            </xsl:when>
                            <xsl:otherwise>String</xsl:otherwise>
                        </xsl:choose>
                    </code>
                </td>
            </xsl:if>
        </tr>
    </xsl:template>
    <xsl:template match="example">
        <source>
            <xsl:value-of select="." />
        </source>
    </xsl:template>
    <xsl:template match="variable">
        <tr>
            <td>
                <xsl:choose>
                    <xsl:when test="name-given">
                        <xsl:value-of select="name-given" />
                        (constant)
                    </xsl:when>
                    <xsl:otherwise>
                        specified via
                        <a href="#{preceding-sibling::name}_{name-from-attribute}">
                            <xsl:value-of select="name-from-attribute" />
                        </a>
                    </xsl:otherwise>
                </xsl:choose>
            </td>
            <td>
                <xsl:value-of select="variable-class" />
            </td>
            <td>
                <xsl:value-of select="scope" />
            </td>
            <td>
                <xsl:value-of select="description|info" />
            </td>
        </tr>
    </xsl:template>
</xsl:stylesheet>