/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.artifact.Artifact;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.SessionEvent;
import org.apache.maven.wagon.events.SessionEventSupport;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferEventSupport;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.repository.Repository;

public abstract class AbstractWagon
implements Wagon {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    protected Repository source;
    protected SessionEventSupport sessionEventSupport = new SessionEventSupport();
    protected TransferEventSupport transferEventSupport = new TransferEventSupport();

    public void addSessionListener(SessionListener sessionListener) {
        this.sessionEventSupport.addSessionListener(sessionListener);
    }

    public void addTransferListener(TransferListener transferListener) {
        this.transferEventSupport.addTransferListener(transferListener);
    }

    protected String artifactPath(Artifact artifact) {
        return this.source.artifactPath(artifact);
    }

    protected String artifactUrl(Artifact artifact) {
        return this.source.artifactUrl(artifact);
    }

    protected abstract void closeConnection() throws ConnectionException;

    public void connect(Repository repository) throws ConnectionException, AuthenticationException {
        if (repository == null) {
            throw new IllegalStateException("The repository specified cannot be null.");
        }
        this.source = repository;
        this.fireSessionOpening();
        this.openConnection();
        this.fireSessionOpened();
    }

    public void disconnect() throws ConnectionException {
        this.fireSessionDisconnecting();
        this.closeConnection();
        this.fireSessionDisconnected();
    }

    protected void fireGetCompleted(String string, File file) {
        long l = System.currentTimeMillis();
        TransferEvent transferEvent = new TransferEvent(this, string, 2, 5);
        transferEvent.setTimestamp(l);
        transferEvent.setLocalFile(file);
        this.transferEventSupport.fireTransferCompleted(transferEvent);
    }

    protected void fireGetStarted(String string, File file) {
        long l = System.currentTimeMillis();
        TransferEvent transferEvent = new TransferEvent(this, string, 1, 5);
        transferEvent.setTimestamp(l);
        transferEvent.setLocalFile(file);
        this.transferEventSupport.fireTransferStarted(transferEvent);
    }

    protected void firePutCompleted(String string, File file) {
        long l = System.currentTimeMillis();
        TransferEvent transferEvent = new TransferEvent(this, string, 2, 6);
        transferEvent.setTimestamp(l);
        transferEvent.setLocalFile(file);
        this.transferEventSupport.fireTransferCompleted(transferEvent);
    }

    protected void firePutStarted(String string, File file) {
        long l = System.currentTimeMillis();
        TransferEvent transferEvent = new TransferEvent(this, string, 1, 6);
        transferEvent.setTimestamp(l);
        transferEvent.setLocalFile(file);
        this.transferEventSupport.fireTransferStarted(transferEvent);
    }

    protected void fireSessionConnectionRefused() {
        long l = System.currentTimeMillis();
        SessionEvent sessionEvent = new SessionEvent((Wagon)this, 4);
        sessionEvent.setTimestamp(l);
        this.sessionEventSupport.fireSessionConnectionRefused(sessionEvent);
    }

    protected void fireSessionDebug(String string) {
        this.sessionEventSupport.fireDebug(string);
    }

    protected void fireSessionDisconnected() {
        long l = System.currentTimeMillis();
        SessionEvent sessionEvent = new SessionEvent((Wagon)this, 3);
        sessionEvent.setTimestamp(l);
        this.sessionEventSupport.fireSessionDisconnected(sessionEvent);
    }

    protected void fireSessionDisconnecting() {
        long l = System.currentTimeMillis();
        SessionEvent sessionEvent = new SessionEvent((Wagon)this, 2);
        sessionEvent.setTimestamp(l);
        this.sessionEventSupport.fireSessionDisconnecting(sessionEvent);
    }

    protected void fireSessionError(Exception exception) {
        long l = System.currentTimeMillis();
        SessionEvent sessionEvent = new SessionEvent((Wagon)this, exception);
        sessionEvent.setTimestamp(l);
        this.sessionEventSupport.fireSessionError(sessionEvent);
    }

    protected void fireSessionLoggedIn() {
        long l = System.currentTimeMillis();
        SessionEvent sessionEvent = new SessionEvent((Wagon)this, 7);
        sessionEvent.setTimestamp(l);
        this.sessionEventSupport.fireSessionLoggedIn(sessionEvent);
    }

    protected void fireSessionLoggedOff() {
        long l = System.currentTimeMillis();
        SessionEvent sessionEvent = new SessionEvent((Wagon)this, 8);
        sessionEvent.setTimestamp(l);
        this.sessionEventSupport.fireSessionLoggedOff(sessionEvent);
    }

    protected void fireSessionOpened() {
        long l = System.currentTimeMillis();
        SessionEvent sessionEvent = new SessionEvent((Wagon)this, 6);
        sessionEvent.setTimestamp(l);
        this.sessionEventSupport.fireSessionOpened(sessionEvent);
    }

    protected void fireSessionOpening() {
        long l = System.currentTimeMillis();
        SessionEvent sessionEvent = new SessionEvent((Wagon)this, 5);
        sessionEvent.setTimestamp(l);
        this.sessionEventSupport.fireSessionOpening(sessionEvent);
    }

    protected void fireTransferDebug(String string) {
        this.transferEventSupport.fireDebug(string);
    }

    protected void fireTransferError(String string, Exception exception) {
        TransferEvent transferEvent = new TransferEvent(this, string, exception);
        this.transferEventSupport.fireTransferError(transferEvent);
    }

    protected void fireTransferProgress(TransferEvent transferEvent) {
        this.transferEventSupport.fireTransferProgress(transferEvent);
    }

    protected String fullArtifactPath(Artifact artifact) {
        return this.source.fullArtifactPath(artifact);
    }

    public abstract void get(String var1, File var2) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException;

    public abstract void get(Artifact var1, File var2) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException;

    public Repository getRepository() {
        return this.source;
    }

    public SessionEventSupport getSessionEventSupport() {
        return this.sessionEventSupport;
    }

    protected void getTransfer(String string, File file, InputStream inputStream, OutputStream outputStream) throws TransferFailedException {
        this.fireGetStarted(string, file);
        try {
            try {
                this.transfer(string, inputStream, outputStream, 5);
            }
            catch (IOException iOException) {
                boolean bl;
                this.fireTransferError(string, iOException);
                if (file.exists() && !(bl = file.delete())) {
                    file.deleteOnExit();
                }
                String string2 = "GET request of: " + string + " from " + this.source.getName() + "failed";
                throw new TransferFailedException(string2, iOException);
            }
            Object var6_8 = null;
            this.shutdownStream(inputStream);
            this.shutdownStream(outputStream);
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.shutdownStream(inputStream);
            this.shutdownStream(outputStream);
            throw throwable;
        }
        this.fireGetCompleted(string, file);
    }

    public TransferEventSupport getTransferEventSupport() {
        return this.transferEventSupport;
    }

    public boolean hasSessionListener(SessionListener sessionListener) {
        return this.sessionEventSupport.hasSessionListener(sessionListener);
    }

    public boolean hasTransferListener(TransferListener transferListener) {
        return this.transferEventSupport.hasTransferListener(transferListener);
    }

    public abstract void openConnection() throws ConnectionException, AuthenticationException;

    public abstract void put(File var1, String var2) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException;

    public abstract void put(File var1, Artifact var2) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException;

    protected void putTransfer(String string, File file, InputStream inputStream, OutputStream outputStream, boolean bl) throws TransferFailedException {
        this.firePutStarted(string, file);
        try {
            try {
                this.transfer(string, inputStream, outputStream, 6);
            }
            catch (IOException iOException) {
                this.fireTransferError(string, iOException);
                String string2 = "PUT request for: " + string + " to " + file.getName() + "failed";
                throw new TransferFailedException(string2, iOException);
            }
            Object var7_8 = null;
            this.shutdownStream(inputStream);
            if (bl) {
                this.shutdownStream(outputStream);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.shutdownStream(inputStream);
            if (bl) {
                this.shutdownStream(outputStream);
            }
            throw throwable;
        }
        this.firePutCompleted(string, file);
    }

    public void removeSessionListener(SessionListener sessionListener) {
        this.sessionEventSupport.removeSessionListener(sessionListener);
    }

    public void removeTransferListener(TransferListener transferListener) {
        this.transferEventSupport.removeTransferListener(transferListener);
    }

    public void setSessionEventSupport(SessionEventSupport sessionEventSupport) {
        this.sessionEventSupport = sessionEventSupport;
    }

    public void setTransferEventSupport(TransferEventSupport transferEventSupport) {
        this.transferEventSupport = transferEventSupport;
    }

    protected void shutdownStream(InputStream inputStream) {
        block2: {
            if (inputStream == null) break block2;
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    protected void shutdownStream(OutputStream outputStream) {
        block2: {
            if (outputStream == null) break block2;
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    protected void transfer(String string, InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[4096];
        TransferEvent transferEvent = new TransferEvent(this, string, 3, n);
        while ((n2 = inputStream.read(byArray)) != -1) {
            transferEvent.setData(byArray, n2);
            this.fireTransferProgress(transferEvent);
            outputStream.write(byArray, 0, n2);
        }
    }
}

