/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import junit.framework.TestCase;

public class FileTestUtils {
    public static final File createDir(String string) throws IOException {
        File file = FileTestUtils.getTestOutputDir();
        File file2 = new File(file, string);
        file2.delete();
        file2.mkdirs();
        if (!file2.exists()) {
            throw new IOException("Unable to create the directory for testdata");
        }
        System.out.println("Creating directory: " + file2);
        return file2;
    }

    public static final File createDir(TestCase testCase) throws IOException {
        return FileTestUtils.createDir(testCase.getName());
    }

    public static final File createUniqueDir(String string) throws IOException {
        String string2 = String.valueOf(string) + System.currentTimeMillis();
        return FileTestUtils.createDir(string2);
    }

    public static final File createUniqueDir(TestCase testCase) throws IOException {
        return FileTestUtils.createUniqueDir(testCase.getName());
    }

    public static final File createUniqueFile(String string) throws IOException {
        return FileTestUtils.createUniqueFile(string, string);
    }

    public static final File createUniqueFile(String string, String string2) throws IOException {
        File file = FileTestUtils.createDir(string);
        File file2 = new File(file, string2);
        return file2;
    }

    public static final File createUniqueFile(TestCase testCase) throws IOException {
        return FileTestUtils.createUniqueFile(testCase.getName());
    }

    public static File generateFile(String string, String string2) throws IOException {
        File file = new File(string);
        file.getParentFile().mkdirs();
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(string2);
        ((Writer)fileWriter).close();
        return file;
    }

    public static final File getTestOutputDir() {
        String string = System.getProperty("java.io.tmpdir");
        String string2 = System.getProperty("basedir", string);
        File file = new File(string2).getAbsoluteFile();
        String string3 = String.valueOf(String.valueOf(file)) + File.separator + "target" + File.separator + "test-output";
        File file2 = new File(string3);
        file2.mkdirs();
        return file2;
    }
}

