/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;

public class LazyFileOutputStream
extends OutputStream {
    private File file;
    private FileOutputStream delegee;

    public LazyFileOutputStream(File file) {
        this.file = file;
    }

    public LazyFileOutputStream(String string) {
        this.file = new File(string);
    }

    public void close() throws IOException {
        if (this.delegee != null) {
            this.delegee.close();
        }
    }

    public boolean equals(Object object) {
        return this.delegee.equals(object);
    }

    public void flush() throws IOException {
        this.delegee.flush();
    }

    public FileChannel getChannel() {
        return this.delegee.getChannel();
    }

    public FileDescriptor getFD() throws IOException {
        return this.delegee.getFD();
    }

    public int hashCode() {
        return this.delegee.hashCode();
    }

    private void initialize() throws FileNotFoundException {
        this.delegee = new FileOutputStream(this.file);
    }

    public String toString() {
        return this.delegee.toString();
    }

    public void write(int n) throws IOException {
        if (this.delegee == null) {
            this.initialize();
        }
        this.delegee.write(n);
    }

    public void write(byte[] byArray) throws IOException {
        if (this.delegee == null) {
            this.initialize();
        }
        this.delegee.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.delegee == null) {
            this.initialize();
        }
        this.delegee.write(byArray, n, n2);
    }
}

