/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.maven.wagon.AbstractWagon;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.LazyFileOutputStream;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.artifact.Artifact;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;

public abstract class StreamWagon
extends AbstractWagon {
    public abstract void closeConnection() throws ConnectionException;

    public void get(String string, File file) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        if (file == null) {
            throw new ResourceDoesNotExistException("get: Destination cannot be null");
        }
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new TransferFailedException("Specified destination directory cannot be created: " + file.getParentFile());
        }
        LazyFileOutputStream lazyFileOutputStream = null;
        lazyFileOutputStream = new LazyFileOutputStream(file);
        InputStream inputStream = this.getInputStream(string);
        if (lazyFileOutputStream == null) {
            throw new TransferFailedException(String.valueOf(this.getRepository().getUrl()) + " - Could not open input stream for resource: '" + string + "'");
        }
        this.getTransfer(string, file, inputStream, lazyFileOutputStream);
    }

    public void get(Artifact artifact, File file) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.get(this.artifactPath(artifact), file);
    }

    public abstract InputStream getInputStream(String var1) throws TransferFailedException, ResourceDoesNotExistException;

    public abstract OutputStream getOutputStream(String var1) throws TransferFailedException;

    public abstract void openConnection() throws ConnectionException, AuthenticationException;

    public void put(File file, String string) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        if (!file.exists()) {
            throw new TransferFailedException("Specified source file does not exist: " + file);
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new TransferFailedException("Cannot read from specified source: " + file.getAbsolutePath());
        }
        OutputStream outputStream = this.getOutputStream(string);
        if (outputStream == null) {
            throw new TransferFailedException(String.valueOf(this.getRepository().getUrl()) + " - Could not open output stream for resource: '" + string + "'");
        }
        this.putTransfer(string, file, fileInputStream, outputStream, true);
    }

    public void put(File file, Artifact artifact) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.put(file, this.artifactPath(artifact));
    }
}

