/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon;

import java.io.File;
import java.io.IOException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.maven.wagon.FileTestUtils;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.artifact.Artifact;
import org.apache.maven.wagon.artifact.DefaultArtifact;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.observers.ChecksumObserver;
import org.apache.maven.wagon.observers.Debug;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.PlexusTestCase;
import org.codehaus.plexus.util.FileUtils;

public abstract class WagonTestCase
extends PlexusTestCase {
    protected static String POM = "pom.xml";
    protected Repository localRepository;
    protected Repository testRepository;
    protected String localRepositoryPath;
    protected Artifact artifact;
    protected File sourceFile;
    protected File destFile;
    protected String resource;
    protected File artifactSourceFile;
    protected File artifactDestFile;
    protected ChecksumObserver checksumObserver = new ChecksumObserver();

    public WagonTestCase(String string) {
        super(string);
    }

    protected void artifactRoundTripTesting() throws Exception {
        this.message("Artifact round trip testing ...");
        this.putArtifact();
        this.getArtifact();
        this.compareContents(this.artifactSourceFile, this.artifactDestFile);
    }

    protected void compareContents(File file, File file2) throws Exception {
        System.out.println("sourceFile = " + file);
        System.out.println("destFile = " + file2);
        System.out.println("---------------------------------------------------------------------------------------------------------");
        System.out.print("Evaluating and comparing ... ");
        String string = FileUtils.fileRead((File)file);
        String string2 = FileUtils.fileRead((File)file2);
        Assert.assertEquals((String)string, (String)string2);
        System.out.println("OK");
        System.out.println("---------------------------------------------------------------------------------------------------------");
    }

    protected Repository createFileRepository(String string) {
        File file = new File(string.substring(7));
        file.mkdirs();
        Repository repository = new Repository();
        repository.setUrl(string);
        return repository;
    }

    protected void customizeContext() throws Exception {
        this.getContainer().addContextValue((Object)"test.repository", (Object)this.localRepositoryPath);
    }

    protected void fileRoundTripTesting() throws Exception {
        this.message("File round trip testing ...");
        this.putFile();
        this.getFile();
        System.out.println("checksumObserver:" + this.checksumObserver);
        System.out.println("actual:" + this.checksumObserver.getActualChecksum());
        System.out.println("expected:" + this.checksumObserver.getExpectedChecksum());
        Assert.assertTrue((boolean)this.checksumObserver.cheksumIsValid());
        this.compareContents(this.sourceFile, this.destFile);
    }

    protected void getArtifact() throws Exception {
        this.message("Getting test artifact from test repository " + this.testRepository);
        Wagon wagon = this.getWagon();
        wagon.connect(this.testRepository);
        this.artifactDestFile = FileTestUtils.createUniqueFile((TestCase)this);
        this.artifactDestFile.deleteOnExit();
        wagon.get(this.getTestArtifact(), this.artifactDestFile);
        wagon.disconnect();
    }

    protected AuthenticationInfo getAuthInfo() {
        return new AuthenticationInfo();
    }

    protected void getFile() throws Exception {
        this.message("Getting test artifact from test repository " + this.testRepository);
        Wagon wagon = this.getWagon();
        wagon.addTransferListener(this.checksumObserver);
        wagon.connect(this.testRepository);
        this.destFile = FileTestUtils.createUniqueFile((TestCase)this);
        this.destFile.deleteOnExit();
        wagon.get(this.resource, this.destFile);
        wagon.removeTransferListener(this.checksumObserver);
        wagon.disconnect();
    }

    protected abstract String getProtocol();

    protected Artifact getTestArtifact() throws Exception {
        if (this.artifact == null) {
            this.artifact = new DefaultArtifact("groupId", "artifactId", "1.0", "pom");
        }
        return this.artifact;
    }

    protected abstract String getTestRepositoryUrl() throws IOException;

    protected Wagon getWagon() throws Exception {
        Wagon wagon = (Wagon)this.lookup(Wagon.ROLE, this.getProtocol());
        Debug debug = new Debug();
        wagon.addSessionListener(debug);
        wagon.addTransferListener(debug);
        return wagon;
    }

    private void message(String string) {
        System.out.println("---------------------------------------------------------------------------------------------------------");
        System.out.println(string);
        System.out.println("---------------------------------------------------------------------------------------------------------");
    }

    protected void putArtifact() throws Exception {
        this.message("Putting file into test repository " + this.testRepository);
        Wagon wagon = this.getWagon();
        wagon.connect(this.testRepository);
        this.artifactSourceFile = new File(this.basedir, POM);
        wagon.put(this.artifactSourceFile, this.getTestArtifact());
        wagon.disconnect();
    }

    protected void putFile() throws Exception {
        this.message("Putting test artifact: " + this.resource + " into test repository " + this.testRepository);
        Wagon wagon = this.getWagon();
        wagon.addTransferListener(this.checksumObserver);
        wagon.connect(this.testRepository);
        this.sourceFile = new File(this.basedir, POM);
        wagon.put(this.sourceFile, this.resource);
        wagon.removeTransferListener(this.checksumObserver);
        wagon.disconnect();
    }

    protected void setupRepositories() throws Exception {
        this.resource = "test-resource.txt";
        this.testRepository = new Repository();
        this.testRepository.setUrl(this.getTestRepositoryUrl());
        this.testRepository.setAuthenticationInfo(this.getAuthInfo());
        this.localRepositoryPath = FileTestUtils.createDir("local-repository").getPath();
        this.localRepository = this.createFileRepository("file://" + this.localRepositoryPath);
        this.message("Local repository: " + this.localRepository);
        File file = new File(this.localRepositoryPath);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    protected void setupWagonTestingFixtures() throws Exception {
    }

    protected void tearDownWagonTestingFixtures() throws Exception {
    }

    public void testWagon() throws Exception {
        this.setupRepositories();
        this.setupWagonTestingFixtures();
        this.fileRoundTripTesting();
        this.artifactRoundTripTesting();
        this.tearDownWagonTestingFixtures();
    }
}

