/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.codehaus.plexus.util.FileUtils;

public class WagonUtils {
    public static void fromString(String string, Wagon wagon, String string2) throws Exception {
        File file = null;
        try {
            file = File.createTempFile("wagon", "tmp");
            FileUtils.fileWrite((String)file.getPath(), (String)string2);
            wagon.put(file, string);
        }
        finally {
            boolean bl;
            Object var5_4 = null;
            if (file != null && !(bl = file.delete())) {
                file.deleteOnExit();
            }
        }
    }

    public static AuthenticationInfo getAuthInfo() {
        AuthenticationInfo authenticationInfo = new AuthenticationInfo();
        String string = WagonUtils.getUserName();
        authenticationInfo.setUserName(string);
        File file = new File(System.getProperty("user.home"), "/.ssh/id_dsa");
        if (file.exists()) {
            authenticationInfo.setPrivateKey(file.getAbsolutePath());
            authenticationInfo.setPassphrase("");
        }
        authenticationInfo.setGroup(WagonUtils.getUserGroup());
        return authenticationInfo;
    }

    private static String getUserGroup() {
        String string = System.getProperty("user.group");
        return string;
    }

    public static String getUserName() {
        String string = System.getProperty("user.name");
        return string;
    }

    public static void putDirectory(File file, Wagon wagon, boolean bl) throws ResourceDoesNotExistException, TransferFailedException, AuthorizationException {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (bl) {
            linkedList.add(file.getName());
        } else {
            linkedList.add("");
        }
        while (!linkedList.isEmpty()) {
            String string = (String)linkedList.removeFirst();
            File file2 = new File(file, string);
            File[] fileArray = file2.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                File file3 = fileArray[n];
                String string2 = string.length() > 0 ? String.valueOf(string) + "/" + file3.getName() : file3.getName();
                if (file3.isDirectory()) {
                    linkedList.add(string2);
                } else {
                    wagon.put(file3, string2);
                }
                ++n;
            }
        }
    }

    public static String toString(String string, Wagon wagon) throws IOException, TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        File file = null;
        try {
            boolean bl;
            String string2;
            file = File.createTempFile("wagon", "tmp");
            wagon.get(string, file);
            String string3 = string2 = FileUtils.fileRead((File)file);
            Object var5_7 = null;
            if (file != null && !(bl = file.delete())) {
                file.deleteOnExit();
            }
            return string3;
        }
        catch (Throwable throwable) {
            block3: {
                boolean bl;
                Object var5_8 = null;
                if (file == null || (bl = file.delete())) break block3;
                file.deleteOnExit();
            }
            throw throwable;
        }
    }
}

