/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.events;

import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.events.WagonEvent;

public class SessionEvent
extends WagonEvent {
    public static final int SESSION_CLOSED = 1;
    public static final int SESSION_DISCONNECTING = 2;
    public static final int SESSION_DISCONNECTED = 3;
    public static final int SESSION_CONNECTION_REFUSED = 4;
    public static final int SESSION_OPENING = 5;
    public static final int SESSION_OPENED = 6;
    public static final int SESSION_LOGGED_IN = 7;
    public static final int SESSION_LOGGED_OFF = 8;
    public static final int SESSION_ERROR_OCCURRED = 9;
    private int eventType;
    private Exception exception;

    public SessionEvent(Wagon wagon, int n) {
        super(wagon);
        this.eventType = n;
    }

    public SessionEvent(Wagon wagon, Exception exception) {
        super(wagon);
        this.exception = exception;
        this.eventType = 9;
    }

    public int getEventType() {
        return this.eventType;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setEventType(int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("Illegal event type: " + n);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
        }
        this.eventType = n;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }
}

