/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.events;

import java.io.File;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.events.WagonEvent;

public class TransferEvent
extends WagonEvent {
    public static final int TRANSFER_STARTED = 1;
    public static final int TRANSFER_COMPLETED = 2;
    public static final int TRANSFER_PROGRESS = 3;
    public static final int TRANSFER_ERROR = 4;
    public static final int REQUEST_GET = 5;
    public static final int REQUEST_PUT = 6;
    private String resource;
    private int eventType;
    private int requestType;
    private byte[] data;
    private int dataLength;
    private Exception exception;
    private long progress;
    private File localFile;

    public TransferEvent(Wagon wagon, String string, int n, int n2) {
        super(wagon);
        this.resource = string;
        this.setEventType(n);
        this.setRequestType(n2);
    }

    public TransferEvent(Wagon wagon, String string, Exception exception) {
        super(wagon);
        this.resource = string;
        this.setEventType(4);
        this.exception = exception;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public int getEventType() {
        return this.eventType;
    }

    public Exception getException() {
        return this.exception;
    }

    public File getLocalFile() {
        return this.localFile;
    }

    public int getRequestType() {
        return this.requestType;
    }

    public String getResource() {
        return this.resource;
    }

    public void setData(byte[] byArray, int n) {
        this.data = byArray;
        this.dataLength = n;
    }

    public void setEventType(int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("Illegal event type: " + n);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
        }
        this.eventType = n;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public void setLocalFile(File file) {
        this.localFile = file;
    }

    public void setRequestType(int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("Illegal request type: " + n);
            }
            case 5: 
            case 6: 
        }
        this.requestType = n;
    }

    public void setResource(String string) {
        this.resource = string;
    }
}

