/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.manager;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.artifact.Artifact;
import org.apache.maven.wagon.manager.WagonManager;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

public class DefaultWagonManager
implements WagonManager,
Contextualizable {
    private List repositories;
    private PlexusContainer container;

    public void addRepository(Repository repository) {
        this.repositories.add(repository);
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    public boolean get(Artifact artifact, File file) throws TransferFailedException {
        boolean bl = false;
        File file2 = null;
        try {
            file2 = File.createTempFile("wagon", "tmp");
            file2.deleteOnExit();
        }
        catch (Exception exception) {
            throw new TransferFailedException("Could not create temporary file for transfering artificat: " + artifact);
        }
        Iterator iterator = this.repositories.iterator();
        while (iterator.hasNext()) {
            Repository repository = (Repository)iterator.next();
            try {
                Wagon wagon = this.getWagon(repository.getProtocol());
                wagon.connect(repository);
                wagon.get(artifact, file2);
                bl = true;
                wagon.disconnect();
                this.releaseWagon(wagon);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (bl) {
            bl = file2.renameTo(file);
        }
        if (file2.exists()) {
            file2.delete();
        }
        return bl;
    }

    public List getRepositories() {
        return this.repositories;
    }

    public Wagon getWagon(String string) throws UnsupportedProtocolException {
        Wagon wagon;
        try {
            wagon = (Wagon)this.container.lookup(Wagon.ROLE, string);
        }
        catch (ComponentLookupException componentLookupException) {
            throw new UnsupportedProtocolException("Cannot find wagon which supports the requested protocol: " + string);
        }
        return wagon;
    }

    public void put(File file, Artifact artifact) throws Exception {
        Iterator iterator = this.repositories.iterator();
        while (iterator.hasNext()) {
            Repository repository = (Repository)iterator.next();
            try {
                Wagon wagon = this.getWagon(repository.getProtocol());
                wagon.connect(repository);
                wagon.put(file, artifact);
                wagon.disconnect();
                this.releaseWagon(wagon);
            }
            catch (UnsupportedProtocolException unsupportedProtocolException) {
                System.out.println("No provider for:" + repository);
            }
            catch (Exception exception) {}
        }
    }

    public void releaseWagon(Wagon wagon) throws Exception {
        this.container.release((Object)wagon);
    }

    public void removeRepository(Repository repository) {
        this.repositories.remove(repository);
    }
}

