/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.observers;

import java.io.File;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonUtils;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

public class ChecksumObserver
implements TransferListener {
    private String algorithm;
    private MessageDigest digester;
    private String expectedChecksum;
    private String actualChecksum;
    private boolean transferingMd5 = false;
    private static Map algorithmExtensionMap = new HashMap();

    static {
        algorithmExtensionMap.put("MD5", ".md5");
        algorithmExtensionMap.put("MD2", ".md2");
        algorithmExtensionMap.put("SHA-1", ".sha1");
    }

    public ChecksumObserver() {
        this("MD5");
    }

    public ChecksumObserver(String string) {
        this.algorithm = string;
    }

    public boolean cheksumIsValid() {
        boolean bl = false;
        if (this.actualChecksum != null && this.expectedChecksum != null) {
            bl = this.actualChecksum.equals(this.expectedChecksum);
        }
        return bl;
    }

    public void debug(String string) {
    }

    protected String encode(byte[] byArray) {
        if (byArray.length != 16) {
            return null;
        }
        String string = "";
        int n = 0;
        while (n < 16) {
            String string2 = Integer.toHexString(byArray[n] & 0xFF);
            string = string2.length() == 1 ? String.valueOf(string) + "0" + string2 : String.valueOf(string) + string2;
            ++n;
        }
        return string.trim();
    }

    public String getActualChecksum() {
        return this.actualChecksum;
    }

    public String getExpectedChecksum() {
        return this.expectedChecksum;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void transferCompleted(TransferEvent transferEvent) {
        block9: {
            if (this.digester == null) {
                return;
            }
            Wagon wagon = transferEvent.getWagon();
            this.actualChecksum = this.encode(this.digester.digest());
            this.digester = null;
            InputStream inputStream = null;
            this.transferingMd5 = true;
            try {
                try {
                    int n = transferEvent.getRequestType();
                    String string = transferEvent.getResource();
                    String string2 = (String)algorithmExtensionMap.get(this.algorithm);
                    if (n == 5) {
                        File file = transferEvent.getLocalFile();
                        File file2 = new File(String.valueOf(file.getPath()) + string2);
                        String string3 = String.valueOf(string) + string2;
                        wagon.get(string3, file2);
                        this.expectedChecksum = FileUtils.fileRead((File)file2).trim();
                    } else {
                        WagonUtils.fromString(String.valueOf(string) + string2, wagon, this.actualChecksum);
                    }
                }
                catch (Exception exception) {
                }
                Object var5_10 = null;
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                Object var5_11 = null;
                if (inputStream != null) {
                    IOUtil.close(inputStream);
                }
                this.transferingMd5 = false;
                throw throwable;
            }
            IOUtil.close(inputStream);
        }
        this.transferingMd5 = false;
    }

    public void transferError(TransferEvent transferEvent) {
        this.digester = null;
    }

    public void transferProgress(TransferEvent transferEvent) {
        if (this.digester != null) {
            byte[] byArray = transferEvent.getData();
            int n = transferEvent.getDataLength();
            this.digester.update(byArray, 0, n);
        }
    }

    public void transferStarted(TransferEvent transferEvent) {
        if (this.transferingMd5) {
            return;
        }
        this.expectedChecksum = null;
        this.actualChecksum = null;
        try {
            this.digester = MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
    }
}

