/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.observers;

import java.io.PrintStream;
import org.apache.maven.wagon.events.SessionEvent;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;

public class Debug
implements SessionListener,
TransferListener {
    private PrintStream out;
    long timestamp;
    long transfer;

    public Debug() {
        this(System.out);
    }

    public Debug(PrintStream printStream) {
        this.out = printStream;
    }

    public void debug(String string) {
        this.out.println(string);
    }

    public void sessionConnectionRefused(SessionEvent sessionEvent) {
        this.out.println(String.valueOf(sessionEvent.getWagon().getRepository().getUrl()) + " - Session: Connection refused");
    }

    public void sessionDisconnected(SessionEvent sessionEvent) {
        this.out.println(String.valueOf(sessionEvent.getWagon().getRepository().getUrl()) + " - Session: Disconnected");
    }

    public void sessionDisconnecting(SessionEvent sessionEvent) {
        this.out.println(String.valueOf(sessionEvent.getWagon().getRepository().getUrl()) + " - Session: Disconnecting  ");
    }

    public void sessionError(SessionEvent sessionEvent) {
        this.out.println(" Session error: " + sessionEvent.getException());
    }

    public void sessionLoggedIn(SessionEvent sessionEvent) {
        this.out.println(String.valueOf(sessionEvent.getWagon().getRepository().getUrl()) + " - Session: Logged in");
    }

    public void sessionLoggedOff(SessionEvent sessionEvent) {
        this.out.println(String.valueOf(sessionEvent.getWagon().getRepository().getUrl()) + " - Session: Logged off");
    }

    public void sessionOpened(SessionEvent sessionEvent) {
        this.out.println(String.valueOf(sessionEvent.getWagon().getRepository().getUrl()) + " - Session: Opened  ");
    }

    public void sessionOpening(SessionEvent sessionEvent) {
    }

    public void transferCompleted(TransferEvent transferEvent) {
        double d = (double)(transferEvent.getTimestamp() - this.timestamp) / 1000.0;
        this.out.println();
        String string = "Transfer finished. " + this.transfer + " bytes copied in " + d + " seconds";
        this.out.println(string);
    }

    public void transferError(TransferEvent transferEvent) {
        this.out.println(" Transfer error: " + transferEvent.getException());
    }

    public void transferProgress(TransferEvent transferEvent) {
        this.out.print("#");
        this.transfer += (long)transferEvent.getDataLength();
    }

    public void transferStarted(TransferEvent transferEvent) {
        this.timestamp = transferEvent.getTimestamp();
        this.transfer = 0L;
        if (transferEvent.getRequestType() == 5) {
            String string = "Downloading: " + transferEvent.getResource() + " from " + transferEvent.getWagon().getRepository().getUrl();
            this.out.println(string);
            this.out.println("");
        } else {
            String string = "Uploading: " + transferEvent.getResource() + " to " + transferEvent.getWagon().getRepository().getUrl();
            this.out.println(string);
            this.out.println("");
        }
    }
}

