/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.maven.wagon.LazyFileOutputStream;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.StreamWagon;
import org.apache.maven.wagon.TransferFailedException;

public class FileWagon
extends StreamWagon {
    public void closeConnection() {
    }

    public InputStream getInputStream(String string) throws TransferFailedException, ResourceDoesNotExistException {
        File file = new File(this.getRepository().getBasedir(), string);
        if (!file.exists()) {
            throw new ResourceDoesNotExistException("File: " + file + " does not exists");
        }
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new TransferFailedException("Could not read from file: " + file.getAbsolutePath(), fileNotFoundException);
        }
    }

    public OutputStream getOutputStream(String string) throws TransferFailedException {
        File file = new File(this.getRepository().getBasedir(), string);
        File file2 = file.getParentFile();
        if (file2 != null && !file2.exists() && !file2.mkdirs()) {
            String string2 = "Some of the requied directories do not exist and could not be create. Requested path:  " + file.getAbsolutePath();
            throw new TransferFailedException(string2);
        }
        return new LazyFileOutputStream(file);
    }

    public void openConnection() {
    }
}

