/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.repository;

import java.io.Serializable;
import org.apache.maven.wagon.PathUtils;
import org.apache.maven.wagon.artifact.Artifact;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.codehaus.plexus.util.StringUtils;

public class Repository
implements Serializable {
    private String id;
    private String name;
    private String host;
    private int port = -1;
    private String basedir;
    private String protocol;
    private String layout;
    private String url;
    private ProxyInfo proxyInfo;
    private AuthenticationInfo authenticationInfo;

    public Repository() {
    }

    public Repository(String string, String string2) {
        this.setId(string);
        this.setUrl(string2);
    }

    public String artifactPath(Artifact artifact) {
        return this.interpolateLayout(artifact.getGroupId(), artifact.getArtifactId(), artifact.getType(), artifact.getVersion());
    }

    public String artifactUrl(Artifact artifact) {
        return String.valueOf(this.getUrl()) + "/" + this.artifactPath(artifact);
    }

    public String fullArtifactPath(Artifact artifact) {
        return String.valueOf(this.getBasedir()) + "/" + this.artifactPath(artifact);
    }

    public AuthenticationInfo getAuthenticationInfo() {
        return this.authenticationInfo;
    }

    public String getBasedir() {
        return this.basedir;
    }

    public String getHost() {
        if (this.host == null) {
            return "localhost";
        }
        return this.host;
    }

    public String getId() {
        return this.id;
    }

    public String getLayout() {
        if (this.layout == null) {
            return "${groupId}/${type}s/${artifactId}-${version}.${type}";
        }
        return this.layout;
    }

    public String getName() {
        return this.name;
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public ProxyInfo getProxyInfo() {
        return this.proxyInfo;
    }

    public String getUrl() {
        if (this.url != null) {
            return this.url;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.protocol);
        stringBuffer.append("://");
        stringBuffer.append(this.host);
        if (this.port != -1) {
            stringBuffer.append(":");
            stringBuffer.append(this.port);
        }
        stringBuffer.append("/");
        stringBuffer.append(this.basedir);
        return stringBuffer.toString();
    }

    private String interpolateLayout(String string, String string2, String string3, String string4) {
        String string5 = this.getLayout();
        string5 = StringUtils.replace((String)string5, (String)"${groupId}", (String)string);
        string5 = StringUtils.replace((String)string5, (String)"${artifactId}", (String)string2);
        string5 = StringUtils.replace((String)string5, (String)"${type}", (String)string3);
        string5 = StringUtils.replace((String)string5, (String)"${version}", (String)string4);
        return string5;
    }

    public void setAuthenticationInfo(AuthenticationInfo authenticationInfo) {
        this.authenticationInfo = authenticationInfo;
    }

    public void setBasedir(String string) {
        this.basedir = string;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setProxyInfo(ProxyInfo proxyInfo) {
        this.proxyInfo = proxyInfo;
    }

    public void setUrl(String string) {
        this.url = string;
        this.host = PathUtils.host(string);
        this.protocol = PathUtils.protocol(string);
        this.port = PathUtils.port(string);
        this.basedir = PathUtils.basedir(string);
    }

    public String toString() {
        if (this.getName() != null) {
            return "[" + this.getName() + "] -> " + this.getUrl();
        }
        return this.getUrl();
    }
}

