
package me.snowdrop.istio.api;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "typeUrl",
    "value"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Any implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("typeUrl")
    @JsonPropertyDescription("")
    private String typeUrl;
    /**
     * 
     * 
     */
    @JsonProperty("value")
    @JsonPropertyDescription("")
    private String value;
    private final static long serialVersionUID = 2384147917044359682L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Any() {
    }

    /**
     * 
     * @param typeUrl
     * @param value
     */
    public Any(String typeUrl, String value) {
        super();
        this.typeUrl = typeUrl;
        this.value = value;
    }

    /**
     * 
     * 
     */
    @JsonProperty("typeUrl")
    public String getTypeUrl() {
        return typeUrl;
    }

    /**
     * 
     * 
     */
    @JsonProperty("typeUrl")
    public void setTypeUrl(String typeUrl) {
        this.typeUrl = typeUrl;
    }

    /**
     * 
     * 
     */
    @JsonProperty("value")
    public String getValue() {
        return value;
    }

    /**
     * 
     * 
     */
    @JsonProperty("value")
    public void setValue(String value) {
        this.value = value;
    }

}
