package me.snowdrop.istio.api;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class AnyBuilder extends AnyFluentImpl<AnyBuilder> implements VisitableBuilder<Any,AnyBuilder>{

    AnyFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public AnyBuilder(){
            this(true);
    }
    public AnyBuilder(Boolean validationEnabled){
            this(new Any(), validationEnabled);
    }
    public AnyBuilder(AnyFluent<?> fluent){
            this(fluent, true);
    }
    public AnyBuilder(AnyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Any(), validationEnabled);
    }
    public AnyBuilder(AnyFluent<?> fluent,Any instance){
            this(fluent, instance, true);
    }
    public AnyBuilder(AnyFluent<?> fluent,Any instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withTypeUrl(instance.getTypeUrl()); 
            fluent.withValue(instance.getValue()); 
            this.validationEnabled = validationEnabled; 
    }
    public AnyBuilder(Any instance){
            this(instance,true);
    }
    public AnyBuilder(Any instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withTypeUrl(instance.getTypeUrl()); 
            this.withValue(instance.getValue()); 
            this.validationEnabled = validationEnabled; 
    }
    public AnyBuilder(Validator validator){
            this(new Any(), true);
    }
    public AnyBuilder(AnyFluent<?> fluent,Any instance,Validator validator){
            this.fluent = fluent; 
            fluent.withTypeUrl(instance.getTypeUrl()); 
            fluent.withValue(instance.getValue()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public AnyBuilder(Any instance,Validator validator){
            this.fluent = this; 
            this.withTypeUrl(instance.getTypeUrl()); 
            this.withValue(instance.getValue()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public Any build(){
            Any buildable = new Any(fluent.getTypeUrl(),fluent.getValue());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AnyBuilder that = (AnyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
