package me.snowdrop.istio.api;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class BoolValueFluentImpl<A extends BoolValueFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements BoolValueFluent<A>{

    private Boolean value;

    public BoolValueFluentImpl(){
    }
    public BoolValueFluentImpl(BoolValue instance){
            this.withValue(instance.getValue()); 
    }

    public Boolean isValue(){
            return this.value;
    }

    public A withValue(Boolean value){
            this.value=value; return (A) this;
    }

    public Boolean hasValue(){
            return this.value != null;
    }

    public A withNewValue(String arg1){
            return (A)withValue(new Boolean(arg1));
    }

    public A withNewValue(boolean arg1){
            return (A)withValue(new Boolean(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BoolValueFluentImpl that = (BoolValueFluentImpl) o;
            if (value != null ? !value.equals(that.value) :that.value != null) return false;
            return true;
    }




}
