package me.snowdrop.istio.api;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.String;
import java.util.LinkedHashMap;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;
import me.snowdrop.istio.api.cexl.TypedValue;

public class StructFluentImpl<A extends StructFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements StructFluent<A>{

    private Map<String,TypedValue> fields;

    public StructFluentImpl(){
    }
    public StructFluentImpl(Struct instance){
            this.withFields(instance.getFields()); 
    }

    public A addToFields(String key,TypedValue value){
            if(this.fields == null && key != null && value != null) { this.fields = new LinkedHashMap<String,TypedValue>(); }
            if(key != null && value != null) {this.fields.put(key, value);} return (A)this;
    }

    public A addToFields(Map<String,TypedValue> map){
            if(this.fields == null && map != null) { this.fields = new LinkedHashMap<String,TypedValue>(); }
            if(map != null) { this.fields.putAll(map);} return (A)this;
    }

    public A removeFromFields(String key){
            if(this.fields == null) { return (A) this; }
            if(key != null && this.fields != null) {this.fields.remove(key);} return (A)this;
    }

    public A removeFromFields(Map<String,TypedValue> map){
            if(this.fields == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.fields != null){this.fields.remove(key);}}} return (A)this;
    }

    public Map<String,TypedValue> getFields(){
            return this.fields;
    }

    public A withFields(Map<String,TypedValue> fields){
            if (fields == null) { this.fields =  null;} else {this.fields = new LinkedHashMap<String,TypedValue>(fields);} return (A) this;
    }

    public Boolean hasFields(){
            return this.fields != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            StructFluentImpl that = (StructFluentImpl) o;
            if (fields != null ? !fields.equals(that.fields) :that.fields != null) return false;
            return true;
    }




}
