package me.snowdrop.istio.api.authentication.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class JwtFluentImpl<A extends JwtFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements JwtFluent<A>{

    private List<String> audiences;
    private String issuer;
    private String jwksUri;
    private List<String> jwtHeaders;
    private List<String> jwtParams;

    public JwtFluentImpl(){
    }
    public JwtFluentImpl(Jwt instance){
            this.withAudiences(instance.getAudiences()); 
            this.withIssuer(instance.getIssuer()); 
            this.withJwksUri(instance.getJwksUri()); 
            this.withJwtHeaders(instance.getJwtHeaders()); 
            this.withJwtParams(instance.getJwtParams()); 
    }

    public A addToAudiences(int index,String item){
            if (this.audiences == null) {this.audiences = new ArrayList<String>();}
            this.audiences.add(index, item);
            return (A)this;
    }

    public A setToAudiences(int index,String item){
            if (this.audiences == null) {this.audiences = new ArrayList<String>();}
            this.audiences.set(index, item); return (A)this;
    }

    public A addToAudiences(String... items){
            if (this.audiences == null) {this.audiences = new ArrayList<String>();}
            for (String item : items) {this.audiences.add(item);} return (A)this;
    }

    public A addAllToAudiences(Collection<String> items){
            if (this.audiences == null) {this.audiences = new ArrayList<String>();}
            for (String item : items) {this.audiences.add(item);} return (A)this;
    }

    public A removeFromAudiences(String... items){
            for (String item : items) {if (this.audiences!= null){ this.audiences.remove(item);}} return (A)this;
    }

    public A removeAllFromAudiences(Collection<String> items){
            for (String item : items) {if (this.audiences!= null){ this.audiences.remove(item);}} return (A)this;
    }

    public List<String> getAudiences(){
            return this.audiences;
    }

    public String getAudience(int index){
            return this.audiences.get(index);
    }

    public String getFirstAudience(){
            return this.audiences.get(0);
    }

    public String getLastAudience(){
            return this.audiences.get(audiences.size() - 1);
    }

    public String getMatchingAudience(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: audiences) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withAudiences(List<String> audiences){
            if (this.audiences != null) { _visitables.removeAll(this.audiences);}
            if (audiences != null) {this.audiences = new ArrayList<String>(); for (String item : audiences){this.addToAudiences(item);}} else { this.audiences = null;} return (A) this;
    }

    public A withAudiences(String... audiences){
            if (this.audiences != null) {this.audiences.clear();}
            if (audiences != null) {for (String item :audiences){ this.addToAudiences(item);}} return (A) this;
    }

    public Boolean hasAudiences(){
            return audiences != null && !audiences.isEmpty();
    }

    public String getIssuer(){
            return this.issuer;
    }

    public A withIssuer(String issuer){
            this.issuer=issuer; return (A) this;
    }

    public Boolean hasIssuer(){
            return this.issuer != null;
    }

    public String getJwksUri(){
            return this.jwksUri;
    }

    public A withJwksUri(String jwksUri){
            this.jwksUri=jwksUri; return (A) this;
    }

    public Boolean hasJwksUri(){
            return this.jwksUri != null;
    }

    public A addToJwtHeaders(int index,String item){
            if (this.jwtHeaders == null) {this.jwtHeaders = new ArrayList<String>();}
            this.jwtHeaders.add(index, item);
            return (A)this;
    }

    public A setToJwtHeaders(int index,String item){
            if (this.jwtHeaders == null) {this.jwtHeaders = new ArrayList<String>();}
            this.jwtHeaders.set(index, item); return (A)this;
    }

    public A addToJwtHeaders(String... items){
            if (this.jwtHeaders == null) {this.jwtHeaders = new ArrayList<String>();}
            for (String item : items) {this.jwtHeaders.add(item);} return (A)this;
    }

    public A addAllToJwtHeaders(Collection<String> items){
            if (this.jwtHeaders == null) {this.jwtHeaders = new ArrayList<String>();}
            for (String item : items) {this.jwtHeaders.add(item);} return (A)this;
    }

    public A removeFromJwtHeaders(String... items){
            for (String item : items) {if (this.jwtHeaders!= null){ this.jwtHeaders.remove(item);}} return (A)this;
    }

    public A removeAllFromJwtHeaders(Collection<String> items){
            for (String item : items) {if (this.jwtHeaders!= null){ this.jwtHeaders.remove(item);}} return (A)this;
    }

    public List<String> getJwtHeaders(){
            return this.jwtHeaders;
    }

    public String getJwtHeader(int index){
            return this.jwtHeaders.get(index);
    }

    public String getFirstJwtHeader(){
            return this.jwtHeaders.get(0);
    }

    public String getLastJwtHeader(){
            return this.jwtHeaders.get(jwtHeaders.size() - 1);
    }

    public String getMatchingJwtHeader(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: jwtHeaders) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withJwtHeaders(List<String> jwtHeaders){
            if (this.jwtHeaders != null) { _visitables.removeAll(this.jwtHeaders);}
            if (jwtHeaders != null) {this.jwtHeaders = new ArrayList<String>(); for (String item : jwtHeaders){this.addToJwtHeaders(item);}} else { this.jwtHeaders = null;} return (A) this;
    }

    public A withJwtHeaders(String... jwtHeaders){
            if (this.jwtHeaders != null) {this.jwtHeaders.clear();}
            if (jwtHeaders != null) {for (String item :jwtHeaders){ this.addToJwtHeaders(item);}} return (A) this;
    }

    public Boolean hasJwtHeaders(){
            return jwtHeaders != null && !jwtHeaders.isEmpty();
    }

    public A addToJwtParams(int index,String item){
            if (this.jwtParams == null) {this.jwtParams = new ArrayList<String>();}
            this.jwtParams.add(index, item);
            return (A)this;
    }

    public A setToJwtParams(int index,String item){
            if (this.jwtParams == null) {this.jwtParams = new ArrayList<String>();}
            this.jwtParams.set(index, item); return (A)this;
    }

    public A addToJwtParams(String... items){
            if (this.jwtParams == null) {this.jwtParams = new ArrayList<String>();}
            for (String item : items) {this.jwtParams.add(item);} return (A)this;
    }

    public A addAllToJwtParams(Collection<String> items){
            if (this.jwtParams == null) {this.jwtParams = new ArrayList<String>();}
            for (String item : items) {this.jwtParams.add(item);} return (A)this;
    }

    public A removeFromJwtParams(String... items){
            for (String item : items) {if (this.jwtParams!= null){ this.jwtParams.remove(item);}} return (A)this;
    }

    public A removeAllFromJwtParams(Collection<String> items){
            for (String item : items) {if (this.jwtParams!= null){ this.jwtParams.remove(item);}} return (A)this;
    }

    public List<String> getJwtParams(){
            return this.jwtParams;
    }

    public String getJwtParam(int index){
            return this.jwtParams.get(index);
    }

    public String getFirstJwtParam(){
            return this.jwtParams.get(0);
    }

    public String getLastJwtParam(){
            return this.jwtParams.get(jwtParams.size() - 1);
    }

    public String getMatchingJwtParam(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: jwtParams) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withJwtParams(List<String> jwtParams){
            if (this.jwtParams != null) { _visitables.removeAll(this.jwtParams);}
            if (jwtParams != null) {this.jwtParams = new ArrayList<String>(); for (String item : jwtParams){this.addToJwtParams(item);}} else { this.jwtParams = null;} return (A) this;
    }

    public A withJwtParams(String... jwtParams){
            if (this.jwtParams != null) {this.jwtParams.clear();}
            if (jwtParams != null) {for (String item :jwtParams){ this.addToJwtParams(item);}} return (A) this;
    }

    public Boolean hasJwtParams(){
            return jwtParams != null && !jwtParams.isEmpty();
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            JwtFluentImpl that = (JwtFluentImpl) o;
            if (audiences != null ? !audiences.equals(that.audiences) :that.audiences != null) return false;
            if (issuer != null ? !issuer.equals(that.issuer) :that.issuer != null) return false;
            if (jwksUri != null ? !jwksUri.equals(that.jwksUri) :that.jwksUri != null) return false;
            if (jwtHeaders != null ? !jwtHeaders.equals(that.jwtHeaders) :that.jwtHeaders != null) return false;
            if (jwtParams != null ? !jwtParams.equals(that.jwtParams) :that.jwtParams != null) return false;
            return true;
    }




}
