package me.snowdrop.istio.api.authentication.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class PolicyListFluentImpl<A extends PolicyListFluent<A>> extends BaseFluent<A> implements PolicyListFluent<A>{

    private String apiVersion;
    private List<PolicyBuilder> items;
    private String kind;
    private ListMeta metadata;

    public PolicyListFluentImpl(){
    }
    public PolicyListFluentImpl(PolicyList instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A addToItems(int index,Policy item){
            if (this.items == null) {this.items = new ArrayList<PolicyBuilder>();}
            PolicyBuilder builder = new PolicyBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToItems(int index,Policy item){
            if (this.items == null) {this.items = new ArrayList<PolicyBuilder>();}
            PolicyBuilder builder = new PolicyBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToItems(Policy... items){
            if (this.items == null) {this.items = new ArrayList<PolicyBuilder>();}
            for (Policy item : items) {PolicyBuilder builder = new PolicyBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToItems(Collection<Policy> items){
            if (this.items == null) {this.items = new ArrayList<PolicyBuilder>();}
            for (Policy item : items) {PolicyBuilder builder = new PolicyBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(Policy... items){
            for (Policy item : items) {PolicyBuilder builder = new PolicyBuilder(item);_visitables.remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromItems(Collection<Policy> items){
            for (Policy item : items) {PolicyBuilder builder = new PolicyBuilder(item);_visitables.remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Policy> getItems(){
            return build(items);
    }

    public List<Policy> buildItems(){
            return build(items);
    }

    public Policy buildItem(int index){
            return this.items.get(index).build();
    }

    public Policy buildFirstItem(){
            return this.items.get(0).build();
    }

    public Policy buildLastItem(){
            return this.items.get(items.size() - 1).build();
    }

    public Policy buildMatchingItem(Predicate<PolicyBuilder> predicate){
            for (PolicyBuilder item: items) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withItems(List<Policy> items){
            if (this.items != null) { _visitables.removeAll(this.items);}
            if (items != null) {this.items = new ArrayList<PolicyBuilder>(); for (Policy item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
    }

    public A withItems(Policy... items){
            if (this.items != null) {this.items.clear();}
            if (items != null) {for (Policy item :items){ this.addToItems(item);}} return (A) this;
    }

    public Boolean hasItems(){
            return items != null && !items.isEmpty();
    }

    public PolicyListFluent.ItemsNested<A> addNewItem(){
            return new ItemsNestedImpl();
    }

    public PolicyListFluent.ItemsNested<A> addNewItemLike(Policy item){
            return new ItemsNestedImpl(-1, item);
    }

    public PolicyListFluent.ItemsNested<A> setNewItemLike(int index,Policy item){
            return new ItemsNestedImpl(index, item);
    }

    public PolicyListFluent.ItemsNested<A> editItem(int index){
            if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
            return setNewItemLike(index, buildItem(index));
    }

    public PolicyListFluent.ItemsNested<A> editFirstItem(){
            if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
            return setNewItemLike(0, buildItem(0));
    }

    public PolicyListFluent.ItemsNested<A> editLastItem(){
            int index = items.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
            return setNewItemLike(index, buildItem(index));
    }

    public PolicyListFluent.ItemsNested<A> editMatchingItem(Predicate<PolicyBuilder> predicate){
            int index = -1;
            for (int i=0;i<items.size();i++) { 
            if (predicate.apply(items.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
            return setNewItemLike(index, buildItem(index));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public ListMeta getMetadata(){
            return this.metadata;
    }

    public A withMetadata(ListMeta metadata){
            this.metadata=metadata; return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public A withNewMetadata(String _continue,String resourceVersion,String selfLink){
            return (A)withMetadata(new ListMeta(_continue, resourceVersion, selfLink));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PolicyListFluentImpl that = (PolicyListFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            return true;
    }


    public class ItemsNestedImpl<N> extends PolicyFluentImpl<PolicyListFluent.ItemsNested<N>> implements PolicyListFluent.ItemsNested<N>,Nested<N>{

            private final PolicyBuilder builder;
        private final int index;
    
            ItemsNestedImpl(int index,Policy item){
                    this.index = index;
                    this.builder = new PolicyBuilder(this, item);
            }
            ItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new PolicyBuilder(this);
            }
    
    public N and(){
            return (N) PolicyListFluentImpl.this.setToItems(index, builder.build());
    }
    public N endItem(){
            return and();
    }

}


}
