
package me.snowdrop.istio.api.authentication.v1alpha1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(using = me.snowdrop.istio.api.internal.ClassWithInterfaceFieldsDeserializer.class)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "port"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class PortSelector implements Serializable
{

    @JsonProperty("port")
    @JsonUnwrapped
    private me.snowdrop.istio.api.authentication.v1alpha1.PortSelector.Port port;
    private final static long serialVersionUID = 8009894999578653479L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public PortSelector() {
    }

    /**
     * 
     * @param port
     */
    public PortSelector(me.snowdrop.istio.api.authentication.v1alpha1.PortSelector.Port port) {
        super();
        this.port = port;
    }

    @JsonProperty("port")
    public me.snowdrop.istio.api.authentication.v1alpha1.PortSelector.Port getPort() {
        return port;
    }

    @JsonProperty("port")
    public void setPort(me.snowdrop.istio.api.authentication.v1alpha1.PortSelector.Port port) {
        this.port = port;
    }

    public interface Port extends Serializable
    {


    }

}
