
package me.snowdrop.istio.api.authentication.v1alpha1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "name",
    "ports"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class TargetSelector implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private String name;
    /**
     * 
     * 
     */
    @JsonProperty("ports")
    @JsonPropertyDescription("")
    @Valid
    private List<PortSelector> ports = new ArrayList<PortSelector>();
    private final static long serialVersionUID = 418017986146762973L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TargetSelector() {
    }

    /**
     * 
     * @param name
     * @param ports
     */
    public TargetSelector(String name, List<PortSelector> ports) {
        super();
        this.name = name;
        this.ports = ports;
    }

    /**
     * 
     * 
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * 
     * 
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 
     * 
     */
    @JsonProperty("ports")
    public List<PortSelector> getPorts() {
        return ports;
    }

    /**
     * 
     * 
     */
    @JsonProperty("ports")
    public void setPorts(List<PortSelector> ports) {
        this.ports = ports;
    }

}
