package me.snowdrop.istio.api.mesh.v1alpha1;

import me.snowdrop.istio.api.DurationFluentImpl;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;
import me.snowdrop.istio.api.Duration;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import me.snowdrop.istio.api.DurationBuilder;

public class ProxyConfigFluentImpl<A extends ProxyConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ProxyConfigFluent<A>{

    private String availabilityZone;
    private String binaryPath;
    private Integer concurrency;
    private String configPath;
    private DurationBuilder connectTimeout;
    private AuthenticationPolicy controlPlaneAuthPolicy;
    private String customConfigFile;
    private String discoveryAddress;
    private DurationBuilder discoveryRefreshDelay;
    private DurationBuilder drainDuration;
    private InboundInterceptionMode interceptionMode;
    private DurationBuilder parentShutdownDuration;
    private Integer proxyAdminPort;
    private String proxyBootstrapTemplatePath;
    private String serviceCluster;
    private Integer statNameLength;
    private String statsdUdpAddress;
    private String zipkinAddress;

    public ProxyConfigFluentImpl(){
    }
    public ProxyConfigFluentImpl(ProxyConfig instance){
            this.withAvailabilityZone(instance.getAvailabilityZone()); 
            this.withBinaryPath(instance.getBinaryPath()); 
            this.withConcurrency(instance.getConcurrency()); 
            this.withConfigPath(instance.getConfigPath()); 
            this.withConnectTimeout(instance.getConnectTimeout()); 
            this.withControlPlaneAuthPolicy(instance.getControlPlaneAuthPolicy()); 
            this.withCustomConfigFile(instance.getCustomConfigFile()); 
            this.withDiscoveryAddress(instance.getDiscoveryAddress()); 
            this.withDiscoveryRefreshDelay(instance.getDiscoveryRefreshDelay()); 
            this.withDrainDuration(instance.getDrainDuration()); 
            this.withInterceptionMode(instance.getInterceptionMode()); 
            this.withParentShutdownDuration(instance.getParentShutdownDuration()); 
            this.withProxyAdminPort(instance.getProxyAdminPort()); 
            this.withProxyBootstrapTemplatePath(instance.getProxyBootstrapTemplatePath()); 
            this.withServiceCluster(instance.getServiceCluster()); 
            this.withStatNameLength(instance.getStatNameLength()); 
            this.withStatsdUdpAddress(instance.getStatsdUdpAddress()); 
            this.withZipkinAddress(instance.getZipkinAddress()); 
    }

    public String getAvailabilityZone(){
            return this.availabilityZone;
    }

    public A withAvailabilityZone(String availabilityZone){
            this.availabilityZone=availabilityZone; return (A) this;
    }

    public Boolean hasAvailabilityZone(){
            return this.availabilityZone != null;
    }

    public String getBinaryPath(){
            return this.binaryPath;
    }

    public A withBinaryPath(String binaryPath){
            this.binaryPath=binaryPath; return (A) this;
    }

    public Boolean hasBinaryPath(){
            return this.binaryPath != null;
    }

    public Integer getConcurrency(){
            return this.concurrency;
    }

    public A withConcurrency(Integer concurrency){
            this.concurrency=concurrency; return (A) this;
    }

    public Boolean hasConcurrency(){
            return this.concurrency != null;
    }

    public A withNewConcurrency(String arg1){
            return (A)withConcurrency(new Integer(arg1));
    }

    public A withNewConcurrency(int arg1){
            return (A)withConcurrency(new Integer(arg1));
    }

    public String getConfigPath(){
            return this.configPath;
    }

    public A withConfigPath(String configPath){
            this.configPath=configPath; return (A) this;
    }

    public Boolean hasConfigPath(){
            return this.configPath != null;
    }

    
/**
 * This method has been deprecated, please use method buildConnectTimeout instead.
 * @return The buildable object.
 */
@Deprecated public Duration getConnectTimeout(){
            return this.connectTimeout!=null?this.connectTimeout.build():null;
    }

    public Duration buildConnectTimeout(){
            return this.connectTimeout!=null?this.connectTimeout.build():null;
    }

    public A withConnectTimeout(Duration connectTimeout){
            _visitables.remove(this.connectTimeout);
            if (connectTimeout!=null){ this.connectTimeout= new DurationBuilder(connectTimeout); _visitables.add(this.connectTimeout);} return (A) this;
    }

    public Boolean hasConnectTimeout(){
            return this.connectTimeout != null;
    }

    public A withNewConnectTimeout(Integer nanos,Long seconds){
            return (A)withConnectTimeout(new Duration(nanos, seconds));
    }

    public ProxyConfigFluent.ConnectTimeoutNested<A> withNewConnectTimeout(){
            return new ConnectTimeoutNestedImpl();
    }

    public ProxyConfigFluent.ConnectTimeoutNested<A> withNewConnectTimeoutLike(Duration item){
            return new ConnectTimeoutNestedImpl(item);
    }

    public ProxyConfigFluent.ConnectTimeoutNested<A> editConnectTimeout(){
            return withNewConnectTimeoutLike(getConnectTimeout());
    }

    public ProxyConfigFluent.ConnectTimeoutNested<A> editOrNewConnectTimeout(){
            return withNewConnectTimeoutLike(getConnectTimeout() != null ? getConnectTimeout(): new DurationBuilder().build());
    }

    public ProxyConfigFluent.ConnectTimeoutNested<A> editOrNewConnectTimeoutLike(Duration item){
            return withNewConnectTimeoutLike(getConnectTimeout() != null ? getConnectTimeout(): item);
    }

    public AuthenticationPolicy getControlPlaneAuthPolicy(){
            return this.controlPlaneAuthPolicy;
    }

    public A withControlPlaneAuthPolicy(AuthenticationPolicy controlPlaneAuthPolicy){
            this.controlPlaneAuthPolicy=controlPlaneAuthPolicy; return (A) this;
    }

    public Boolean hasControlPlaneAuthPolicy(){
            return this.controlPlaneAuthPolicy != null;
    }

    public String getCustomConfigFile(){
            return this.customConfigFile;
    }

    public A withCustomConfigFile(String customConfigFile){
            this.customConfigFile=customConfigFile; return (A) this;
    }

    public Boolean hasCustomConfigFile(){
            return this.customConfigFile != null;
    }

    public String getDiscoveryAddress(){
            return this.discoveryAddress;
    }

    public A withDiscoveryAddress(String discoveryAddress){
            this.discoveryAddress=discoveryAddress; return (A) this;
    }

    public Boolean hasDiscoveryAddress(){
            return this.discoveryAddress != null;
    }

    
/**
 * This method has been deprecated, please use method buildDiscoveryRefreshDelay instead.
 * @return The buildable object.
 */
@Deprecated public Duration getDiscoveryRefreshDelay(){
            return this.discoveryRefreshDelay!=null?this.discoveryRefreshDelay.build():null;
    }

    public Duration buildDiscoveryRefreshDelay(){
            return this.discoveryRefreshDelay!=null?this.discoveryRefreshDelay.build():null;
    }

    public A withDiscoveryRefreshDelay(Duration discoveryRefreshDelay){
            _visitables.remove(this.discoveryRefreshDelay);
            if (discoveryRefreshDelay!=null){ this.discoveryRefreshDelay= new DurationBuilder(discoveryRefreshDelay); _visitables.add(this.discoveryRefreshDelay);} return (A) this;
    }

    public Boolean hasDiscoveryRefreshDelay(){
            return this.discoveryRefreshDelay != null;
    }

    public A withNewDiscoveryRefreshDelay(Integer nanos,Long seconds){
            return (A)withDiscoveryRefreshDelay(new Duration(nanos, seconds));
    }

    public ProxyConfigFluent.DiscoveryRefreshDelayNested<A> withNewDiscoveryRefreshDelay(){
            return new DiscoveryRefreshDelayNestedImpl();
    }

    public ProxyConfigFluent.DiscoveryRefreshDelayNested<A> withNewDiscoveryRefreshDelayLike(Duration item){
            return new DiscoveryRefreshDelayNestedImpl(item);
    }

    public ProxyConfigFluent.DiscoveryRefreshDelayNested<A> editDiscoveryRefreshDelay(){
            return withNewDiscoveryRefreshDelayLike(getDiscoveryRefreshDelay());
    }

    public ProxyConfigFluent.DiscoveryRefreshDelayNested<A> editOrNewDiscoveryRefreshDelay(){
            return withNewDiscoveryRefreshDelayLike(getDiscoveryRefreshDelay() != null ? getDiscoveryRefreshDelay(): new DurationBuilder().build());
    }

    public ProxyConfigFluent.DiscoveryRefreshDelayNested<A> editOrNewDiscoveryRefreshDelayLike(Duration item){
            return withNewDiscoveryRefreshDelayLike(getDiscoveryRefreshDelay() != null ? getDiscoveryRefreshDelay(): item);
    }

    
/**
 * This method has been deprecated, please use method buildDrainDuration instead.
 * @return The buildable object.
 */
@Deprecated public Duration getDrainDuration(){
            return this.drainDuration!=null?this.drainDuration.build():null;
    }

    public Duration buildDrainDuration(){
            return this.drainDuration!=null?this.drainDuration.build():null;
    }

    public A withDrainDuration(Duration drainDuration){
            _visitables.remove(this.drainDuration);
            if (drainDuration!=null){ this.drainDuration= new DurationBuilder(drainDuration); _visitables.add(this.drainDuration);} return (A) this;
    }

    public Boolean hasDrainDuration(){
            return this.drainDuration != null;
    }

    public A withNewDrainDuration(Integer nanos,Long seconds){
            return (A)withDrainDuration(new Duration(nanos, seconds));
    }

    public ProxyConfigFluent.DrainDurationNested<A> withNewDrainDuration(){
            return new DrainDurationNestedImpl();
    }

    public ProxyConfigFluent.DrainDurationNested<A> withNewDrainDurationLike(Duration item){
            return new DrainDurationNestedImpl(item);
    }

    public ProxyConfigFluent.DrainDurationNested<A> editDrainDuration(){
            return withNewDrainDurationLike(getDrainDuration());
    }

    public ProxyConfigFluent.DrainDurationNested<A> editOrNewDrainDuration(){
            return withNewDrainDurationLike(getDrainDuration() != null ? getDrainDuration(): new DurationBuilder().build());
    }

    public ProxyConfigFluent.DrainDurationNested<A> editOrNewDrainDurationLike(Duration item){
            return withNewDrainDurationLike(getDrainDuration() != null ? getDrainDuration(): item);
    }

    public InboundInterceptionMode getInterceptionMode(){
            return this.interceptionMode;
    }

    public A withInterceptionMode(InboundInterceptionMode interceptionMode){
            this.interceptionMode=interceptionMode; return (A) this;
    }

    public Boolean hasInterceptionMode(){
            return this.interceptionMode != null;
    }

    
/**
 * This method has been deprecated, please use method buildParentShutdownDuration instead.
 * @return The buildable object.
 */
@Deprecated public Duration getParentShutdownDuration(){
            return this.parentShutdownDuration!=null?this.parentShutdownDuration.build():null;
    }

    public Duration buildParentShutdownDuration(){
            return this.parentShutdownDuration!=null?this.parentShutdownDuration.build():null;
    }

    public A withParentShutdownDuration(Duration parentShutdownDuration){
            _visitables.remove(this.parentShutdownDuration);
            if (parentShutdownDuration!=null){ this.parentShutdownDuration= new DurationBuilder(parentShutdownDuration); _visitables.add(this.parentShutdownDuration);} return (A) this;
    }

    public Boolean hasParentShutdownDuration(){
            return this.parentShutdownDuration != null;
    }

    public A withNewParentShutdownDuration(Integer nanos,Long seconds){
            return (A)withParentShutdownDuration(new Duration(nanos, seconds));
    }

    public ProxyConfigFluent.ParentShutdownDurationNested<A> withNewParentShutdownDuration(){
            return new ParentShutdownDurationNestedImpl();
    }

    public ProxyConfigFluent.ParentShutdownDurationNested<A> withNewParentShutdownDurationLike(Duration item){
            return new ParentShutdownDurationNestedImpl(item);
    }

    public ProxyConfigFluent.ParentShutdownDurationNested<A> editParentShutdownDuration(){
            return withNewParentShutdownDurationLike(getParentShutdownDuration());
    }

    public ProxyConfigFluent.ParentShutdownDurationNested<A> editOrNewParentShutdownDuration(){
            return withNewParentShutdownDurationLike(getParentShutdownDuration() != null ? getParentShutdownDuration(): new DurationBuilder().build());
    }

    public ProxyConfigFluent.ParentShutdownDurationNested<A> editOrNewParentShutdownDurationLike(Duration item){
            return withNewParentShutdownDurationLike(getParentShutdownDuration() != null ? getParentShutdownDuration(): item);
    }

    public Integer getProxyAdminPort(){
            return this.proxyAdminPort;
    }

    public A withProxyAdminPort(Integer proxyAdminPort){
            this.proxyAdminPort=proxyAdminPort; return (A) this;
    }

    public Boolean hasProxyAdminPort(){
            return this.proxyAdminPort != null;
    }

    public A withNewProxyAdminPort(String arg1){
            return (A)withProxyAdminPort(new Integer(arg1));
    }

    public A withNewProxyAdminPort(int arg1){
            return (A)withProxyAdminPort(new Integer(arg1));
    }

    public String getProxyBootstrapTemplatePath(){
            return this.proxyBootstrapTemplatePath;
    }

    public A withProxyBootstrapTemplatePath(String proxyBootstrapTemplatePath){
            this.proxyBootstrapTemplatePath=proxyBootstrapTemplatePath; return (A) this;
    }

    public Boolean hasProxyBootstrapTemplatePath(){
            return this.proxyBootstrapTemplatePath != null;
    }

    public String getServiceCluster(){
            return this.serviceCluster;
    }

    public A withServiceCluster(String serviceCluster){
            this.serviceCluster=serviceCluster; return (A) this;
    }

    public Boolean hasServiceCluster(){
            return this.serviceCluster != null;
    }

    public Integer getStatNameLength(){
            return this.statNameLength;
    }

    public A withStatNameLength(Integer statNameLength){
            this.statNameLength=statNameLength; return (A) this;
    }

    public Boolean hasStatNameLength(){
            return this.statNameLength != null;
    }

    public A withNewStatNameLength(String arg1){
            return (A)withStatNameLength(new Integer(arg1));
    }

    public A withNewStatNameLength(int arg1){
            return (A)withStatNameLength(new Integer(arg1));
    }

    public String getStatsdUdpAddress(){
            return this.statsdUdpAddress;
    }

    public A withStatsdUdpAddress(String statsdUdpAddress){
            this.statsdUdpAddress=statsdUdpAddress; return (A) this;
    }

    public Boolean hasStatsdUdpAddress(){
            return this.statsdUdpAddress != null;
    }

    public String getZipkinAddress(){
            return this.zipkinAddress;
    }

    public A withZipkinAddress(String zipkinAddress){
            this.zipkinAddress=zipkinAddress; return (A) this;
    }

    public Boolean hasZipkinAddress(){
            return this.zipkinAddress != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ProxyConfigFluentImpl that = (ProxyConfigFluentImpl) o;
            if (availabilityZone != null ? !availabilityZone.equals(that.availabilityZone) :that.availabilityZone != null) return false;
            if (binaryPath != null ? !binaryPath.equals(that.binaryPath) :that.binaryPath != null) return false;
            if (concurrency != null ? !concurrency.equals(that.concurrency) :that.concurrency != null) return false;
            if (configPath != null ? !configPath.equals(that.configPath) :that.configPath != null) return false;
            if (connectTimeout != null ? !connectTimeout.equals(that.connectTimeout) :that.connectTimeout != null) return false;
            if (controlPlaneAuthPolicy != null ? !controlPlaneAuthPolicy.equals(that.controlPlaneAuthPolicy) :that.controlPlaneAuthPolicy != null) return false;
            if (customConfigFile != null ? !customConfigFile.equals(that.customConfigFile) :that.customConfigFile != null) return false;
            if (discoveryAddress != null ? !discoveryAddress.equals(that.discoveryAddress) :that.discoveryAddress != null) return false;
            if (discoveryRefreshDelay != null ? !discoveryRefreshDelay.equals(that.discoveryRefreshDelay) :that.discoveryRefreshDelay != null) return false;
            if (drainDuration != null ? !drainDuration.equals(that.drainDuration) :that.drainDuration != null) return false;
            if (interceptionMode != null ? !interceptionMode.equals(that.interceptionMode) :that.interceptionMode != null) return false;
            if (parentShutdownDuration != null ? !parentShutdownDuration.equals(that.parentShutdownDuration) :that.parentShutdownDuration != null) return false;
            if (proxyAdminPort != null ? !proxyAdminPort.equals(that.proxyAdminPort) :that.proxyAdminPort != null) return false;
            if (proxyBootstrapTemplatePath != null ? !proxyBootstrapTemplatePath.equals(that.proxyBootstrapTemplatePath) :that.proxyBootstrapTemplatePath != null) return false;
            if (serviceCluster != null ? !serviceCluster.equals(that.serviceCluster) :that.serviceCluster != null) return false;
            if (statNameLength != null ? !statNameLength.equals(that.statNameLength) :that.statNameLength != null) return false;
            if (statsdUdpAddress != null ? !statsdUdpAddress.equals(that.statsdUdpAddress) :that.statsdUdpAddress != null) return false;
            if (zipkinAddress != null ? !zipkinAddress.equals(that.zipkinAddress) :that.zipkinAddress != null) return false;
            return true;
    }


    public class ConnectTimeoutNestedImpl<N> extends DurationFluentImpl<ProxyConfigFluent.ConnectTimeoutNested<N>> implements ProxyConfigFluent.ConnectTimeoutNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            ConnectTimeoutNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            ConnectTimeoutNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) ProxyConfigFluentImpl.this.withConnectTimeout(builder.build());
    }
    public N endConnectTimeout(){
            return and();
    }

}
    public class DiscoveryRefreshDelayNestedImpl<N> extends DurationFluentImpl<ProxyConfigFluent.DiscoveryRefreshDelayNested<N>> implements ProxyConfigFluent.DiscoveryRefreshDelayNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            DiscoveryRefreshDelayNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            DiscoveryRefreshDelayNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) ProxyConfigFluentImpl.this.withDiscoveryRefreshDelay(builder.build());
    }
    public N endDiscoveryRefreshDelay(){
            return and();
    }

}
    public class DrainDurationNestedImpl<N> extends DurationFluentImpl<ProxyConfigFluent.DrainDurationNested<N>> implements ProxyConfigFluent.DrainDurationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            DrainDurationNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            DrainDurationNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) ProxyConfigFluentImpl.this.withDrainDuration(builder.build());
    }
    public N endDrainDuration(){
            return and();
    }

}
    public class ParentShutdownDurationNestedImpl<N> extends DurationFluentImpl<ProxyConfigFluent.ParentShutdownDurationNested<N>> implements ProxyConfigFluent.ParentShutdownDurationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            ParentShutdownDurationNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            ParentShutdownDurationNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) ProxyConfigFluentImpl.this.withParentShutdownDuration(builder.build());
    }
    public N endParentShutdownDuration(){
            return and();
    }

}


}
