package me.snowdrop.istio.api.mixer.v1;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class AttributeMatchFluentImpl<A extends AttributeMatchFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements AttributeMatchFluent<A>{

    private Condition condition;
    private Integer mapKey;
    private Integer name;
    private String regex;

    public AttributeMatchFluentImpl(){
    }
    public AttributeMatchFluentImpl(AttributeMatch instance){
            this.withCondition(instance.getCondition()); 
            this.withMapKey(instance.getMapKey()); 
            this.withName(instance.getName()); 
            this.withRegex(instance.getRegex()); 
    }

    public Condition getCondition(){
            return this.condition;
    }

    public A withCondition(Condition condition){
            this.condition=condition; return (A) this;
    }

    public Boolean hasCondition(){
            return this.condition != null;
    }

    public Integer getMapKey(){
            return this.mapKey;
    }

    public A withMapKey(Integer mapKey){
            this.mapKey=mapKey; return (A) this;
    }

    public Boolean hasMapKey(){
            return this.mapKey != null;
    }

    public A withNewMapKey(String arg1){
            return (A)withMapKey(new Integer(arg1));
    }

    public A withNewMapKey(int arg1){
            return (A)withMapKey(new Integer(arg1));
    }

    public Integer getName(){
            return this.name;
    }

    public A withName(Integer name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new Integer(arg1));
    }

    public A withNewName(int arg1){
            return (A)withName(new Integer(arg1));
    }

    public String getRegex(){
            return this.regex;
    }

    public A withRegex(String regex){
            this.regex=regex; return (A) this;
    }

    public Boolean hasRegex(){
            return this.regex != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AttributeMatchFluentImpl that = (AttributeMatchFluentImpl) o;
            if (condition != null ? !condition.equals(that.condition) :that.condition != null) return false;
            if (mapKey != null ? !mapKey.equals(that.mapKey) :that.mapKey != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (regex != null ? !regex.equals(that.regex) :that.regex != null) return false;
            return true;
    }




}
