package me.snowdrop.istio.api.mixer.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;
import me.snowdrop.istio.api.cexl.TypedValue;

public interface AttributesFluent<A extends AttributesFluent<A>> extends Fluent<A>{


    public A addToAttributes(String key,TypedValue value);
    public A addToAttributes(Map<String,TypedValue> map);
    public A removeFromAttributes(String key);
    public A removeFromAttributes(Map<String,TypedValue> map);
    public Map<String,TypedValue> getAttributes();
    public A withAttributes(Map<String,TypedValue> attributes);
    public Boolean hasAttributes();



}
