package me.snowdrop.istio.api.mixer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class CheckRequestBuilder extends CheckRequestFluentImpl<CheckRequestBuilder> implements VisitableBuilder<CheckRequest,CheckRequestBuilder>{

    CheckRequestFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public CheckRequestBuilder(){
            this(true);
    }
    public CheckRequestBuilder(Boolean validationEnabled){
            this(new CheckRequest(), validationEnabled);
    }
    public CheckRequestBuilder(CheckRequestFluent<?> fluent){
            this(fluent, true);
    }
    public CheckRequestBuilder(CheckRequestFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new CheckRequest(), validationEnabled);
    }
    public CheckRequestBuilder(CheckRequestFluent<?> fluent,CheckRequest instance){
            this(fluent, instance, true);
    }
    public CheckRequestBuilder(CheckRequestFluent<?> fluent,CheckRequest instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAttributes(instance.getAttributes()); 
            fluent.withDeduplicationId(instance.getDeduplicationId()); 
            fluent.withGlobalWordCount(instance.getGlobalWordCount()); 
            fluent.withQuotas(instance.getQuotas()); 
            this.validationEnabled = validationEnabled; 
    }
    public CheckRequestBuilder(CheckRequest instance){
            this(instance,true);
    }
    public CheckRequestBuilder(CheckRequest instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAttributes(instance.getAttributes()); 
            this.withDeduplicationId(instance.getDeduplicationId()); 
            this.withGlobalWordCount(instance.getGlobalWordCount()); 
            this.withQuotas(instance.getQuotas()); 
            this.validationEnabled = validationEnabled; 
    }
    public CheckRequestBuilder(Validator validator){
            this(new CheckRequest(), true);
    }
    public CheckRequestBuilder(CheckRequestFluent<?> fluent,CheckRequest instance,Validator validator){
            this.fluent = fluent; 
            fluent.withAttributes(instance.getAttributes()); 
            fluent.withDeduplicationId(instance.getDeduplicationId()); 
            fluent.withGlobalWordCount(instance.getGlobalWordCount()); 
            fluent.withQuotas(instance.getQuotas()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public CheckRequestBuilder(CheckRequest instance,Validator validator){
            this.fluent = this; 
            this.withAttributes(instance.getAttributes()); 
            this.withDeduplicationId(instance.getDeduplicationId()); 
            this.withGlobalWordCount(instance.getGlobalWordCount()); 
            this.withQuotas(instance.getQuotas()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public CheckRequest build(){
            CheckRequest buildable = new CheckRequest(fluent.getAttributes(),fluent.getDeduplicationId(),fluent.getGlobalWordCount(),fluent.getQuotas());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CheckRequestBuilder that = (CheckRequestBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
