package me.snowdrop.istio.api.mixer.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;

public class QuotaResultFluentImpl<A extends QuotaResultFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements QuotaResultFluent<A>{

    private Long grantedAmount;
    private ReferencedAttributesBuilder referencedAttributes;
    private Long validDuration;

    public QuotaResultFluentImpl(){
    }
    public QuotaResultFluentImpl(QuotaResult instance){
            this.withGrantedAmount(instance.getGrantedAmount()); 
            this.withReferencedAttributes(instance.getReferencedAttributes()); 
            this.withValidDuration(instance.getValidDuration()); 
    }

    public Long getGrantedAmount(){
            return this.grantedAmount;
    }

    public A withGrantedAmount(Long grantedAmount){
            this.grantedAmount=grantedAmount; return (A) this;
    }

    public Boolean hasGrantedAmount(){
            return this.grantedAmount != null;
    }

    public A withNewGrantedAmount(String arg1){
            return (A)withGrantedAmount(new Long(arg1));
    }

    public A withNewGrantedAmount(long arg1){
            return (A)withGrantedAmount(new Long(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildReferencedAttributes instead.
 * @return The buildable object.
 */
@Deprecated public ReferencedAttributes getReferencedAttributes(){
            return this.referencedAttributes!=null?this.referencedAttributes.build():null;
    }

    public ReferencedAttributes buildReferencedAttributes(){
            return this.referencedAttributes!=null?this.referencedAttributes.build():null;
    }

    public A withReferencedAttributes(ReferencedAttributes referencedAttributes){
            _visitables.remove(this.referencedAttributes);
            if (referencedAttributes!=null){ this.referencedAttributes= new ReferencedAttributesBuilder(referencedAttributes); _visitables.add(this.referencedAttributes);} return (A) this;
    }

    public Boolean hasReferencedAttributes(){
            return this.referencedAttributes != null;
    }

    public QuotaResultFluent.ReferencedAttributesNested<A> withNewReferencedAttributes(){
            return new ReferencedAttributesNestedImpl();
    }

    public QuotaResultFluent.ReferencedAttributesNested<A> withNewReferencedAttributesLike(ReferencedAttributes item){
            return new ReferencedAttributesNestedImpl(item);
    }

    public QuotaResultFluent.ReferencedAttributesNested<A> editReferencedAttributes(){
            return withNewReferencedAttributesLike(getReferencedAttributes());
    }

    public QuotaResultFluent.ReferencedAttributesNested<A> editOrNewReferencedAttributes(){
            return withNewReferencedAttributesLike(getReferencedAttributes() != null ? getReferencedAttributes(): new ReferencedAttributesBuilder().build());
    }

    public QuotaResultFluent.ReferencedAttributesNested<A> editOrNewReferencedAttributesLike(ReferencedAttributes item){
            return withNewReferencedAttributesLike(getReferencedAttributes() != null ? getReferencedAttributes(): item);
    }

    public Long getValidDuration(){
            return this.validDuration;
    }

    public A withValidDuration(Long validDuration){
            this.validDuration=validDuration; return (A) this;
    }

    public Boolean hasValidDuration(){
            return this.validDuration != null;
    }

    public A withNewValidDuration(String arg1){
            return (A)withValidDuration(new Long(arg1));
    }

    public A withNewValidDuration(long arg1){
            return (A)withValidDuration(new Long(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            QuotaResultFluentImpl that = (QuotaResultFluentImpl) o;
            if (grantedAmount != null ? !grantedAmount.equals(that.grantedAmount) :that.grantedAmount != null) return false;
            if (referencedAttributes != null ? !referencedAttributes.equals(that.referencedAttributes) :that.referencedAttributes != null) return false;
            if (validDuration != null ? !validDuration.equals(that.validDuration) :that.validDuration != null) return false;
            return true;
    }


    public class ReferencedAttributesNestedImpl<N> extends ReferencedAttributesFluentImpl<QuotaResultFluent.ReferencedAttributesNested<N>> implements QuotaResultFluent.ReferencedAttributesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ReferencedAttributesBuilder builder;
    
            ReferencedAttributesNestedImpl(ReferencedAttributes item){
                    this.builder = new ReferencedAttributesBuilder(this, item);
            }
            ReferencedAttributesNestedImpl(){
                    this.builder = new ReferencedAttributesBuilder(this);
            }
    
    public N and(){
            return (N) QuotaResultFluentImpl.this.withReferencedAttributes(builder.build());
    }
    public N endReferencedAttributes(){
            return and();
    }

}


}
