package me.snowdrop.istio.api.mixer.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class StringMapFluentImpl<A extends StringMapFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements StringMapFluent<A>{

    private Map<String,Integer> entries;

    public StringMapFluentImpl(){
    }
    public StringMapFluentImpl(StringMap instance){
            this.withEntries(instance.getEntries()); 
    }

    public A addToEntries(String key,Integer value){
            if(this.entries == null && key != null && value != null) { this.entries = new LinkedHashMap<String,Integer>(); }
            if(key != null && value != null) {this.entries.put(key, value);} return (A)this;
    }

    public A addToEntries(Map<String,Integer> map){
            if(this.entries == null && map != null) { this.entries = new LinkedHashMap<String,Integer>(); }
            if(map != null) { this.entries.putAll(map);} return (A)this;
    }

    public A removeFromEntries(String key){
            if(this.entries == null) { return (A) this; }
            if(key != null && this.entries != null) {this.entries.remove(key);} return (A)this;
    }

    public A removeFromEntries(Map<String,Integer> map){
            if(this.entries == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.entries != null){this.entries.remove(key);}}} return (A)this;
    }

    public Map<String,Integer> getEntries(){
            return this.entries;
    }

    public A withEntries(Map<String,Integer> entries){
            if (entries == null) { this.entries =  null;} else {this.entries = new LinkedHashMap<String,Integer>(entries);} return (A) this;
    }

    public Boolean hasEntries(){
            return this.entries != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            StringMapFluentImpl that = (StringMapFluentImpl) o;
            if (entries != null ? !entries.equals(that.entries) :that.entries != null) return false;
            return true;
    }




}
