
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(using = me.snowdrop.istio.api.internal.ClassWithInterfaceFieldsDeserializer.class)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "errorType",
    "percent"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Abort implements Serializable
{

    @JsonProperty("errorType")
    @JsonUnwrapped
    private me.snowdrop.istio.api.networking.v1alpha3.Abort.ErrorType errorType;
    /**
     * 
     * 
     */
    @JsonProperty("percent")
    @JsonPropertyDescription("")
    private Integer percent;
    private final static long serialVersionUID = -3264778220399700660L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Abort() {
    }

    /**
     * 
     * @param errorType
     * @param percent
     */
    public Abort(me.snowdrop.istio.api.networking.v1alpha3.Abort.ErrorType errorType, Integer percent) {
        super();
        this.errorType = errorType;
        this.percent = percent;
    }

    @JsonProperty("errorType")
    public me.snowdrop.istio.api.networking.v1alpha3.Abort.ErrorType getErrorType() {
        return errorType;
    }

    @JsonProperty("errorType")
    public void setErrorType(me.snowdrop.istio.api.networking.v1alpha3.Abort.ErrorType errorType) {
        this.errorType = errorType;
    }

    /**
     * 
     * 
     */
    @JsonProperty("percent")
    public Integer getPercent() {
        return percent;
    }

    /**
     * 
     * 
     */
    @JsonProperty("percent")
    public void setPercent(Integer percent) {
        this.percent = percent;
    }

    public interface ErrorType extends Serializable
    {


    }

}
