
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "consistentHash"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class ConsistentHash implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("consistentHash")
    @JsonPropertyDescription("")
    @Valid
    private ConsistentHashLB consistentHash;
    private final static long serialVersionUID = -3184996453570068720L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ConsistentHash() {
    }

    /**
     * 
     * @param consistentHash
     */
    public ConsistentHash(ConsistentHashLB consistentHash) {
        super();
        this.consistentHash = consistentHash;
    }

    /**
     * 
     * 
     */
    @JsonProperty("consistentHash")
    public ConsistentHashLB getConsistentHash() {
        return consistentHash;
    }

    /**
     * 
     * 
     */
    @JsonProperty("consistentHash")
    public void setConsistentHash(ConsistentHashLB consistentHash) {
        this.consistentHash = consistentHash;
    }

}
