
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.BoolValue;
import me.snowdrop.istio.api.Duration;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "allowCredentials",
    "allowHeaders",
    "allowMethods",
    "allowOrigin",
    "exposeHeaders",
    "maxAge"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class CorsPolicy implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("allowCredentials")
    @JsonPropertyDescription("")
    @Valid
    private BoolValue allowCredentials;
    /**
     * 
     * 
     */
    @JsonProperty("allowHeaders")
    @JsonPropertyDescription("")
    @Valid
    private List<String> allowHeaders = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("allowMethods")
    @JsonPropertyDescription("")
    @Valid
    private List<String> allowMethods = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("allowOrigin")
    @JsonPropertyDescription("")
    @Valid
    private List<String> allowOrigin = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("exposeHeaders")
    @JsonPropertyDescription("")
    @Valid
    private List<String> exposeHeaders = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("maxAge")
    @JsonPropertyDescription("")
    @Valid
    private Duration maxAge;
    private final static long serialVersionUID = -1235226315261052105L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public CorsPolicy() {
    }

    /**
     * 
     * @param allowMethods
     * @param allowHeaders
     * @param exposeHeaders
     * @param maxAge
     * @param allowCredentials
     * @param allowOrigin
     */
    public CorsPolicy(BoolValue allowCredentials, List<String> allowHeaders, List<String> allowMethods, List<String> allowOrigin, List<String> exposeHeaders, Duration maxAge) {
        super();
        this.allowCredentials = allowCredentials;
        this.allowHeaders = allowHeaders;
        this.allowMethods = allowMethods;
        this.allowOrigin = allowOrigin;
        this.exposeHeaders = exposeHeaders;
        this.maxAge = maxAge;
    }

    /**
     * 
     * 
     */
    @JsonProperty("allowCredentials")
    public BoolValue getAllowCredentials() {
        return allowCredentials;
    }

    /**
     * 
     * 
     */
    @JsonProperty("allowCredentials")
    public void setAllowCredentials(BoolValue allowCredentials) {
        this.allowCredentials = allowCredentials;
    }

    /**
     * 
     * 
     */
    @JsonProperty("allowHeaders")
    public List<String> getAllowHeaders() {
        return allowHeaders;
    }

    /**
     * 
     * 
     */
    @JsonProperty("allowHeaders")
    public void setAllowHeaders(List<String> allowHeaders) {
        this.allowHeaders = allowHeaders;
    }

    /**
     * 
     * 
     */
    @JsonProperty("allowMethods")
    public List<String> getAllowMethods() {
        return allowMethods;
    }

    /**
     * 
     * 
     */
    @JsonProperty("allowMethods")
    public void setAllowMethods(List<String> allowMethods) {
        this.allowMethods = allowMethods;
    }

    /**
     * 
     * 
     */
    @JsonProperty("allowOrigin")
    public List<String> getAllowOrigin() {
        return allowOrigin;
    }

    /**
     * 
     * 
     */
    @JsonProperty("allowOrigin")
    public void setAllowOrigin(List<String> allowOrigin) {
        this.allowOrigin = allowOrigin;
    }

    /**
     * 
     * 
     */
    @JsonProperty("exposeHeaders")
    public List<String> getExposeHeaders() {
        return exposeHeaders;
    }

    /**
     * 
     * 
     */
    @JsonProperty("exposeHeaders")
    public void setExposeHeaders(List<String> exposeHeaders) {
        this.exposeHeaders = exposeHeaders;
    }

    /**
     * 
     * 
     */
    @JsonProperty("maxAge")
    public Duration getMaxAge() {
        return maxAge;
    }

    /**
     * 
     * 
     */
    @JsonProperty("maxAge")
    public void setMaxAge(Duration maxAge) {
        this.maxAge = maxAge;
    }

}
