
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(using = me.snowdrop.istio.api.internal.ClassWithInterfaceFieldsDeserializer.class)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "httpDelayType",
    "percent"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Delay implements Serializable
{

    @JsonProperty("httpDelayType")
    @JsonUnwrapped
    private me.snowdrop.istio.api.networking.v1alpha3.Delay.HttpDelayType httpDelayType;
    /**
     * 
     * 
     */
    @JsonProperty("percent")
    @JsonPropertyDescription("")
    private Integer percent;
    private final static long serialVersionUID = 5515373037187589927L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Delay() {
    }

    /**
     * 
     * @param httpDelayType
     * @param percent
     */
    public Delay(me.snowdrop.istio.api.networking.v1alpha3.Delay.HttpDelayType httpDelayType, Integer percent) {
        super();
        this.httpDelayType = httpDelayType;
        this.percent = percent;
    }

    @JsonProperty("httpDelayType")
    public me.snowdrop.istio.api.networking.v1alpha3.Delay.HttpDelayType getHttpDelayType() {
        return httpDelayType;
    }

    @JsonProperty("httpDelayType")
    public void setHttpDelayType(me.snowdrop.istio.api.networking.v1alpha3.Delay.HttpDelayType httpDelayType) {
        this.httpDelayType = httpDelayType;
    }

    /**
     * 
     * 
     */
    @JsonProperty("percent")
    public Integer getPercent() {
        return percent;
    }

    /**
     * 
     * 
     */
    @JsonProperty("percent")
    public void setPercent(Integer percent) {
        this.percent = percent;
    }

    public interface HttpDelayType extends Serializable
    {


    }

}
