package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class DestinationWeightBuilder extends DestinationWeightFluentImpl<DestinationWeightBuilder> implements VisitableBuilder<DestinationWeight,DestinationWeightBuilder>{

    DestinationWeightFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public DestinationWeightBuilder(){
            this(true);
    }
    public DestinationWeightBuilder(Boolean validationEnabled){
            this(new DestinationWeight(), validationEnabled);
    }
    public DestinationWeightBuilder(DestinationWeightFluent<?> fluent){
            this(fluent, true);
    }
    public DestinationWeightBuilder(DestinationWeightFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new DestinationWeight(), validationEnabled);
    }
    public DestinationWeightBuilder(DestinationWeightFluent<?> fluent,DestinationWeight instance){
            this(fluent, instance, true);
    }
    public DestinationWeightBuilder(DestinationWeightFluent<?> fluent,DestinationWeight instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDestination(instance.getDestination()); 
            fluent.withWeight(instance.getWeight()); 
            this.validationEnabled = validationEnabled; 
    }
    public DestinationWeightBuilder(DestinationWeight instance){
            this(instance,true);
    }
    public DestinationWeightBuilder(DestinationWeight instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDestination(instance.getDestination()); 
            this.withWeight(instance.getWeight()); 
            this.validationEnabled = validationEnabled; 
    }
    public DestinationWeightBuilder(Validator validator){
            this(new DestinationWeight(), true);
    }
    public DestinationWeightBuilder(DestinationWeightFluent<?> fluent,DestinationWeight instance,Validator validator){
            this.fluent = fluent; 
            fluent.withDestination(instance.getDestination()); 
            fluent.withWeight(instance.getWeight()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public DestinationWeightBuilder(DestinationWeight instance,Validator validator){
            this.fluent = this; 
            this.withDestination(instance.getDestination()); 
            this.withWeight(instance.getWeight()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public DestinationWeight build(){
            DestinationWeight buildable = new DestinationWeight(fluent.getDestination(),fluent.getWeight());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DestinationWeightBuilder that = (DestinationWeightBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
