package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class HTTPCookieBuilder extends HTTPCookieFluentImpl<HTTPCookieBuilder> implements VisitableBuilder<HTTPCookie,HTTPCookieBuilder>{

    HTTPCookieFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public HTTPCookieBuilder(){
            this(true);
    }
    public HTTPCookieBuilder(Boolean validationEnabled){
            this(new HTTPCookie(), validationEnabled);
    }
    public HTTPCookieBuilder(HTTPCookieFluent<?> fluent){
            this(fluent, true);
    }
    public HTTPCookieBuilder(HTTPCookieFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new HTTPCookie(), validationEnabled);
    }
    public HTTPCookieBuilder(HTTPCookieFluent<?> fluent,HTTPCookie instance){
            this(fluent, instance, true);
    }
    public HTTPCookieBuilder(HTTPCookieFluent<?> fluent,HTTPCookie instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withPath(instance.getPath()); 
            fluent.withTtl(instance.getTtl()); 
            this.validationEnabled = validationEnabled; 
    }
    public HTTPCookieBuilder(HTTPCookie instance){
            this(instance,true);
    }
    public HTTPCookieBuilder(HTTPCookie instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withPath(instance.getPath()); 
            this.withTtl(instance.getTtl()); 
            this.validationEnabled = validationEnabled; 
    }
    public HTTPCookieBuilder(Validator validator){
            this(new HTTPCookie(), true);
    }
    public HTTPCookieBuilder(HTTPCookieFluent<?> fluent,HTTPCookie instance,Validator validator){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withPath(instance.getPath()); 
            fluent.withTtl(instance.getTtl()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public HTTPCookieBuilder(HTTPCookie instance,Validator validator){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withPath(instance.getPath()); 
            this.withTtl(instance.getTtl()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public HTTPCookie build(){
            HTTPCookie buildable = new HTTPCookie(fluent.getName(),fluent.getPath(),fluent.getTtl());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HTTPCookieBuilder that = (HTTPCookieBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
